
'
'    Copyright 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 
'              2019, 2020, 2021: 
'       Dr. Karl-Heinz Schmidt, Rheinstrasse 4, 64390 Erzhausen, Germany
'       and 
'       Dr. Beatriz Jurado, Centre d'Etudes Nucleaires de Bordeaux-Gradignan,
'       Chemin du Solarium, Le Haut Vigneau, BP 120, 33175 Gradignan, Cedex,
'       France 
'
'    This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


  /' Documentation: '/
  /' (1) K.-H. Schmidt and B. Jurado, Contribution to '/
  /'     ESNT Workshop "The scission process", Saclay (France), April 12-16, 2010 '/
  /' (2) B. Jurado and K.-H. Schmidt, Contribution to '/
  /'     Seminar an fission, Gent (Belgium), May 17-20, 2010 '/
  /' (3) B. Jurado and K.-H. Schmidt, Contribution to '/
  /'     EFNUDAT Workshop, Paris (France), May 25-27, 2010 '/
  /' (4) K.-H. Schmidt and B. Jurado, Contribution to '/
  /'     EFNUDAT Workshop, Paris (France), May 25-27, 2010 '/
  /' (5) K.-H. Schmidt and B. Jurado, '/
  /'     Final Report to EFNUDAT, October, 2010 '/
  /' (6) K.-H. Schmidt and B. Jurado, Phys. Rev. Lett. 104 (2010) 21250 '/
  /' (7) K.-H. Schmidt and B. Jurado, Phys. Rev. C 82 (2011) 014607 '/
  /' (8) K.-H. Schmidt and B. Jurado, Phys. Rev. C 83 (2011) 061601 '/
  /' (9) K.-H. Schmidt and B. Jurado, arXiv:1007.0741v1[nucl-th] (2010) '/
  /' (10) K.-H. Schmidt and B. Jurado, JEF/DOC 1423, NEA of OECD, 2012 '/  
  /' (11) K.-H. Schmidt and B. Jurado, Phys. Rev. C 86 (2012) 044322 '/
  /' (12) K.-H. Schmidt, B. Jurado, Ch. Amouroux, JEFF-Report 24, NEA of OECD, 2014 '/
  /' (13) B. Jurado, K.-H. Schmidt, J. Phys. G: Nucl. Part. Phys. 42 (2015) 055101 '/
  /' (14) K.-H. Schmidt, B. Jurado, Eur. Phys. J. A 51 (2015) 176 '/
  /' (15) K.-H. Schmidt, B. Jurado, C. Amouroux, C. Schmitt, Nucl. Data Sheets 131 (2016) 107 '/
  /' (16) K.-H. Schmidt, B. Jurado, Rep. Progr. Phys. 81 (2018) 106301 '/


  /' Further documentation and the newest version of the GEF code are '/
  /' available from                                                   '/
  /' http://www.cenbg.in2p3.fr/GEF and http://www.khs-erzhausen.de/ . '/

  
'    The development of the GEF code has been supported by the European Union,
'    EURATOM 6 in the Framework Program "European Facilities for Nuclear Data
'    Measurements" (EFNUDAT), contract number FP6-036434, the Framework
'    Program "European Research Infrastructure for Nuclear Data Applications
'    (ERINDA), contract number FP7-269499, by the OECD Nuclear Energy Agency
'    (from 2010 to 2016), and by the University Nantes (2018).


' Technical remark: The code contains commented sections with 
' produce a deterministic version of the GEF code as a subroutine from this 
' source with a dedicated pre-processor, named ExtractSub.bas. 
' are used in the deterministic GEF version.
' ExtractSub.bas produces the deterministic code GEFSUB.bas in FreeBASIC.
' The translator FBtoFO.bas can be used to translate this code into FORTRAN99.
' In order to enable this translation, GEF.bas contains already some additional
' statements ( e.g.  /'<FO REAL*4 GAUSSINTEGRAL FO>'/ )   
' that are only used by the translator to provide some specific 
' FORTRAN statements that cannot be produced automatically. 
   

  /' K.-H. Schmidt / B. Jurado, 07/Feb./2009 '/
  /' SEFI9 is taken as a basis and extended by new features in SEFI14 (May 2010), KHS '/
  /' Several improvements (even-odd effect, charge polarization etc. (June 2010), KHS '/
  /' SEFI15 converted from PL/I to FreeBASIC on 04/July/2010, KHS '/
  /' Error in LyPair corrected (26/July/2010) KHS '/
  /' Indices corrected in U_Shell inside Eva (1/Aug/2010) KHS '/
  /' Major developments, sigma_E*(scission), sigma_Z(A) etc. (14/Aug/2010) KHS '/
  /' Macroscopic masses from Thomas-Fermi model (Myers & Swiatecki) (17/Aug/2010) KHS '/
  /' 3 reference options for energy input (4/Sept/2010) KHS '/
  /' Graphic output of mass distribution added (if there are problems with the X11 
      installation on LINUX, the graphics may be suppressed by simply commenting 
      the line  -> #Include Once "DCLPlotting.bas" <- )  (5/Sept/2010) KHS '/
  /' Comparison with ENDF compilation in graphic output (12/Sept/2010) KHS '/
  /' Super-long fission channel included (14/Sept/2010) KHS '/
  /' Overlap of S1 and S2 fission channels in both fragments included (18/Oct/2010) KHS '/
  /' Output of neutron multiplicity distribution added (20/Oct/2010) KHS '/
  /' Decreasing curvature of shells with increasing E* (24/Oct/2010) KHS '/
  /' Angular momenta of fission fragments added (18/Dec/2010) KHS '/
  /' CN angular momentum considered (14/Jan/2011) KHS '/
  /' Numerical stability improved (28/Jan/2011) KHS '/
  /' Output in ENDF format (optional) (4/Feb/2011) KHS '/
  /' Input list from file supported (31/Jan/2011) KHS '/
  /' Multiprocessing supported (5/Feb/2011) KHS '/
  /' Polarization for symmetric fission channel improved (12/Feb/2011) KHS '/
  /' GUI for input (23/Feb/2011) KHS '/
  /' Calculation of fission-fragment angular momentum refined (5/May/2011) KHS '/
  /' Neutron inverse cross section modified (5/August/2011) KHS '/
  /' Even-odd staggering in neutron emission improved (5/August/2011) KHS '/
  /' Slight modifications in angular-momentum distributions (19/October/2011) KHS '/
  /' Gamma emission added (23/November/2011) KHS '/
  /' TKE added (24/November/2011) KHS '/
  /' Neutron spectrum added (25/November/2011) KHS '/
  /' Neutron-gamma competition added (4/December/2011) KHS '/
  /' Composite level density (Egidy + Ignatyuk) refined (31/January/2012) KHS '/
  /' Treatment of GDR refined (14/February/2012) KHS '/
  /' Deformation of S3 channel changed (27/February/2012) KHS '/
  /' Z=44 deformed shell added (supports S1 around Pu) (27/February/2012) KHS '/
  /' Uncertainties from perturbed fission yields (3/March/2012) KHS '/
  /' Validity range extended to Z=120 (with a warning message) (8/March/2012) KHS '/
  /' Neutron emission during fragment acceleration (18/March/2012) KHS '/
  /' Several optimizations (15/April/2012) KHS '/
  /' TF masses of Myers & Swiatecki corrected (pairing shift) (29/May/2012) KHS '/
  /' Correction on intrinsic excitation energy (05/June/2012) KHS '/
  /' Correction on gamma emission (25/September/2012) KHS '/
  /' Free choice of listmode values (13/October/2012) KHS '/
  /' Excitation-energy distribution from file (14/October/2012) KHS '/
  /' Transfer of input from GUI corrected (02/November/2012) KHS '/
  /' Parameters of perturbed calculations modified (02/November/2012) KHS '/
  /' Model parameters je-adjusted (08/November/2012) KHS '/
  /' Input options for isomeric target nuclei (09/November/2012) KHS '/
  /' Random initialisation of the random generator (26/November/2012) KHS '/
  /' Covariance matrix for Z, Apre, Apost, ZApre, ZApost (06/December/2012) KHS '/
  /' Output file in XML format (06/December/2012) KHS '/
  /' Multi-chance fission supported (13/December/2012) KHS '/
  /' Pre-compound emission for (n,f) included (13/December/2012) KHS '/
  /' Some technical corrections and modifications (17/December/2012) KHS '/
  /' Transition from asymmetric to symmetric fission around Fm improved (19/December/2012) KHS '/
  /' Influence of S2 channel on S1 channel in the other fragment included (20/December/2012) KHS'/
  /' List-mode output of pre-fission neutron energies (21/December/2012) KHS '/
  /' Parameterisation for EB-EA from fit to data in Dahlinger et al. (21/December/2012) KHS '/
  /' Fission channel at Z=42 added (seen around Pu in light fragment and around Hg) (23/Dec./2012) KHS '/
  /' Gamma-n / Gamma-f according to Moretto (IAEA Rochester) (23/December/2012) KHS '/
  /' Pre-compound neutron energies modified (24/December/2012) KHS '/
  /' Some technical revisions to avoid crashes in covariances (26/December/2012) KHS '/
  /' Influence of shells on yrast line from Deleplanque et al. (26/December/2012) KHS '/
  /' Fission threshold in multi-chance fission modified (30/December/2012) KHS '/
  /' Output of energies at fission for multi-chance fission (30/December/2012) KHS '/
  /' Several revisions (15/January/2013) KHS '/
  /' New optical model fit (3/February/2013) KHS '/
  /' Gamma-f / Gamma-n modified (3/February/2013) KHS '/
  /' Handling for reading input from file corrected (5/February/2013) KHS '/ 
  /' Data transfer from GUI corrected (6/February/2013) KHS '/
  /' Input dialog re-organized (6/February/2013) KHS '/  
  /' Mass-dependent deformation and charge polarization revised (9/February/2013) KHS '/
  /' Calculation of combined fission channels S12, S22 revised (10/February/2013) KHS '/
  /' Extension of validity range to heavier nuclei (10/February/2013) KHS '/
  /' Improved description of prompt-neutron spectra (21/February/2013) KHS '/
  /' Several technical corrections and developments (April-May/2013) KHS '/
  /' Pre-fission emission of protons considered (14/Mai,2013) KHS '/
  /' Structure of energy list in input file modified (26/May/2013) KHS '/
  /' Option "local fit" added (26/May/2013) KHS '/
  /' Neutron evaporation corrected (more realistic even-odd effect in isotonic distr.) (21/June(2013) KHS '/
  /' Even-odd effect in TKE added (23/June/2013) KHS '/
  /' Calculation of Z-A-covariance matrix corrected (16/July/2013) KHS '/ 
  /' Output of multi-variate distributions corrected for input from file (24/July/2013) KHS '/
  /' New global fit (most important: Energy gain from saddle to scission reduced) (15/September/2013) KHS '/
  /' Even-odd effect in neutron number of fragments modified (17/September/2013) KHS '/
  /' Curvatures of fission valleys adjusted to experimental shells around 132Sn (18/September/2013) KHS '/
  /' Width of S0 corrected: Fit of Rusanov (18/September/2013) KHS '/
  /' Random generator Box with asymmetric diffuseness for S2 (18/September/2013) KHS '/
  /' Gaussian random generator revised (20/September/2013) KHS '/
  /' Mass shift of fission channels with E* modified (22/September/2013) KHS '/
  /' Energy dependence of S1 position corrected, slightly modified parameters (25/September/2013) KHS '/
  /' Initial angular momentum introduced as an input parameter (02/October/2013) KHS '/
  /' Calculation of prompt-neutron emission improved, some model parameters modified (12/October/2013) KHS '/
  /' Technical error, causing incomplete covariance matrices on output corrected  (17/October/2013) KHS '/
  /' Washing of shell effects considerd in shape fluctuations (26/October/2013) KHS '/
  /' Post-scission neutrons added to list-mode output (8/November/2013) KHS '/
  /' Fission-gamma competition refined (10/November/2013) KHS '/
  /' New global fit of model parameters (18/November/2013) KHS '/
  /' Multi-chance fission modified (18/November/2013) KHS '/
  /' A numerical instability removed (20/November/2013) KHS '/
  /' Calculation of multi-chance fission: corrected and modified (28/November/2013) KHS '/
  /' Spurious even-odd effect in fission probabilities (from Moeller's shells) removed (4/December/2013) KHS '/
  /' More precise calculation of E* in n-induced fission (6/December/2013) KHS '/
  /' Pre-fission gamma strength increased (adjusted to Pf(E*) of 238U (22/December/2013) KHS '/
  /' Kinetic energy of prompt neutrons in cm system (fragment-neutron) (10/Janurary/2014) KHS '/
  /' Binnig of prompt-neutron spectra corrected (shift by 50 keV) (10/January/2014) KHS '/
  /' Description of fission barriers modified (15/January/2014) KHS '/
  /' Description of energy-dependent fission probability modified (17/January/2014) KHS '/
  /' E* at scission modified for fission below Bf (4/February/2014) KHS '/
  /' Influence of Z=44 shell on deformation of light fragment (4/February/2014) KHS '/
  /' Tunneling for S1 enhanced (16/February/2014) KHS '/
  /' New global fit of fission channels (strength and position) (19/March/2014) KHS '/
  /' Normalization of distributions for deterministic version corrected (23/May/2014) KHS '/
  /' Calculation of "corrected sample variance" revised (05/September/2014) KHS '/
  /' Uncertainties calculated with "corrected sample variance" (05/September/2014) KHS '/
  /' Shape of "S22" fission channel modified (08/December/2014) KHS '/
  /' Binsize for prompt neutrons set to 1 keV (09/December/2014) KHS '/
  /' Binsize for prompt gammas set to 1 keV (09/December/2014) KHS '/
  /' Fragment excitation energies in listmode (10/December/2014) KHS '/
  /' Shell in symmetric fission channel included in GEFSUB (12/December/2014) KHS '/
  /' Ground-state spin of fragments is taken into account (22/January/2015) KHS '/
  /' Pre-fission gamma emission included (20/February/2015) KHS '/
  /' VMI model for E2 gammas developed and implemented (15/March/2015) KHS '/
  /' Binning of spectrum EN corrected (28/March/2015) KHS '/ 
  /' Energetics of symmetric fission channel revised (5/April/2015) KHS '/
  /' Output of isomeric yields extended (# of events added) (10/April/2015) KHS '/
  /' Control-output for progress of calculation (17/April/2015) KHS '/
  /' Angular-momentum dependence of pairing gap in eva (7/May/2015) KHS '/
  /' Angular-momentum dependent Gf: influence of fissility and temperature (13/May/2015) KHS '/
  /' Influence of angular momentum on mass width by increasing fissiliy (14/May/2015) KHS '/
  /' Mass distribution truncated at zero and A_CN (14/May/2015) KHS '/
  /' Yields of fission modes also for multi-chance fission (7/August/2015) KHS '/
  /' Tentative description of structure in FF distributions around A_CN = 180-200 (8/August/2015) KHS '/
  /' Improved description of asymmetric fission in light nuclei (A_CN < 220) (9/August/2015) KHS '/
  /' Extension of the validity range to lighter nuclei (9/August/2015) KHS '/
  /' Adaptions of ERF function to new FreeBASIC compiler (12/Sept(2015) KHS '/
  /' Allowance for calculations with very large number of events (15/Sept(2015) KHS '/
  /' Slight adjustement of parameters to "repair" deterioation for low E* (21/Sept/2015) KHS '/
  /' Correction of some formatting issues (03/Oct/2015) KHS '/
  /' Calculation of covariances for independent yields corrected (6/Nov/2015) KHS '/
  /' Calculation of covariances between two systems corrected (6/Nov/2015) KHS '/
  /' Output of correlations matrices added (6/Nov/2015) KHS '/
  /' Espectrum.in can now also provide the CN spin (13/Nov/2015) KHS '/
  /' Output for parallel computing better protected (1/March/2016) KHS '/
  /' Output of random files provided (4/March/2016) KHS '/
  /' Prompt-neutron spectrum with variable bin size added (6/April/2016) KHS '/
  /' Overflow problem in tanh and coth corrected (11/April/2016) KHS '/
  /' Experimental masses in evaporation routine (not yet finished) (23/April/2016) KHS '/
  /' Subscriptrange problem in output of neutron energies corrected (29/April/2016) KHS '/  
  /' Gamma spectra with conditions on pre-neutron mass (29/Mai/2016) KHS '/
  /' Relation between energies: experimental masses used (07/Sept/2016) KHS '/
  /' Partial support of p-induced fission (up to Ep = 30 MeV)
       (pre-equilibrium emission not yet implemented, preliminary l-distribution) (07/Sept/2016) KHS '/
  /' Model parameters of fission channels optimized (20/Sept/2016) KHS '/
  /' Neutrons emitted between outer saddle and scission added (21/Sept/2016) KHS '/  
  /' Output of delayed-neutron multiplicities added (25/Sept/2016) KHS '/
  /' New adjustment of model parameters (13/Oct/2016) KHS '/  
  /' Output of delayed-neutron emitters added (13/Oct/2016) KHS '/ 
  /' Uncertainty range of angular momentum added (24/Oct/2016) KHS '/
  /' Uncertainties of prompt-gamma and prompt-neutron characteristics added (24/Oct/2016) KHS '/
  /' Uncertainty of TKE (pre and post) added (06/Nov/2016) KHS '/
  /' Normalization of Maxwell distribution corrected (07/Nov/2016) KHS '/
  /' Declaration of some variables changed to prevent overflow (24/Nov/2016) KHS '/
  /' Energy dependence of shape fluctuations modified (26/Nov/2016) KHS '/
  /' Formatting of output slightly modified (15/Dec/2016,15/May/2017) KHS '/
  /' Fission probabilities added to output (01/Jul/2017) KHS '/
  /' Calculation of correlations between two systems allowed from input file (25/Jul/2017) KHS '/
  /' Input options from file implemented (27/July/2017) KHS '/
  /' Fluctuation of E_intr modified (only E* over Bf considered) (22/Sept/2017) KHS '/
  /' Fluctuation of neck distance introduced (22/Sept/2017) KHS '/
  /' New adjustment of fit parameters with special care for 235U(nth,f), 
        data point for A=129 from ENDF replaced by other measurement (23/Sept/2017) KHS '/
  /' Adjustment of mass-dependent prompt-neutron multiplicities, new general fit (27/Sept./2017) KHS '/
  /' Extension of energy range for energy sorting (27/Sept/2017) KHS '/  
  /' New fit with shape of S2 closer to a Gaussian (3/Oct/2017) KHS '/    
  /' Symmetric fission channel at low energies revised (7/Oct/2017) KHS '/
  /' New comprehensive fit of model parameters (18-31/Oct/2017) KHS '/
  /' Spurious structure at symmetry in pre-neutron yields removed (30/Oct/2017) KHS '/
  /' Odd-even effect on Pf modified (31/Oct/2017) KHS '/
  /' Numerical problem in odd-even effect in Z and A of light nuclei corrected (16/Nov/2017) KHS '/
  /' Minimum collective temperature reduced (16/Nov/2017) KHS '/
  /' Improved parameters of the Z=38 shell (16-22/Nov/2017) KHS '/
  /' Sequence of energy values from file allowed for options "GS" and "EB" (24/Nov/2017) KHS '/
  /' Shell effect in fission probability revised (27/Nov/2017) KHS '/
  /' Calculation of fission probabilities modified (5-20/Dec/2017) KHS '/
  /' Scaling factor for variation of perturbed parameters introduced (20/Jan/2018) KHS '/   
  /' Hbar-Omeaga of charge polarization modified (better agreement with radiochemical data) (24/Jan/2018) KHS '/
  /' Model parameters better adjusted to independent yields of 235U(nth,f) (28/Jan/2018) KHS '/
  /' Calculation of covariances/correlations between 2 systems corrected (29/Jan/2018) KHS '/
  /' New optimization of model parameters (27/Mar/2018) KHS '/
  /' Several simultaneous calculations of the same systems with different energies enabled (27/Mar/2018) KHS '/
  /' Several systems from JEFF 3.1.1 and JEFF 3.3 added to DCLPlotting.bas (28/Mar/2018) KHS '/
  /' Energies and spins for calculation of isomeric yields from NUBASE (31/Mar/2018) KHS '/
  /' Input dialog (Linux) revised (10/Apr/2018) KHS '/
  /' New optimization of model parameters (28/Apr/2018) KHS '/
  /' Assumed uncertainties of parameter values reduced by a factor of 0.6 (28/Apr/2018) KHS '/
  /' Neutron emission between saddle and scission corrected (10/June/2018) KHS '/
  /' Overflow problem in calculation of fission chances solved (09/July/2018) KHS '/
  /' Shell effect at symmetry is washed out in Getyield with increasing E* (9/Aug/2018) KHS '/
  /' More flexible handling of plotting (15/Dec/2018) KHS '/
  /' More options for calculations from file (e.g. energy spectrum) (15/Dec/2018) KHS '/
  /' NucpropNUBASE.bas: estimated data included (16/Dec/2018) KHS '/
  /' Windows version: Technical problem with GUI corrected (18/Dec/2018) KHS '/
  /' File name for energy spectrum on input can be freely chosen in dialog and batch mode (17/Dec/2018) KHS '/
  /' Output of prompt-neutron mean energies extended (30/Dec/2018) KHS '/
  /' Protection of validity range softened (28/Jan/2019) KHS '/
  /' Influence of N=50 shell on charge polarisation introduced (30/Jan/2019) KHS '/  
  /' Spread of gamma energy due to spin of statistical photons introduced (03/Feb/2019) KHS '/
  /' Calculation of fission probability revised (04/Feb/2019) KHS '/
  /' Options "delayed processes" and "ENDF output" separated (09/Feb/2019) KHS '/
  /' Option E* distribution from file with multi-chance fission introduced (17/Feb/2019) KHS '/
  /' Mass-dependent modification of symmetric fission valley around 229Th introduced (05/Mar/2019) KHS '/
  /' Parametrization of the S3 fission channel modified (11/Mar/2019) KHS '/
  /' Delta_S0 parameter values revised (15/Mar/2019) KHS '/
  /' Output of E*-dependent Pfis for option "EM" (15/Apr/2019) KHS '/ 
  /' Momentum of incident particle: effect on pre-fission particle emission and fragments 
                                   (17/Apr/2019) KHS '/ 
  /' Direction in space of pre-scission particles and fragments included in
     list-mode output (17/Apr/2019) KHS '/  
  /' List-mode output of particle kinematics extended (06/May/2019) KHS '/    
  /' Option PnCN in GUI corrected (05/June/2019) KHS '/
  /' Excitation energy used for fission from multi-chance section corrected (06/June/2019) KHS '/   
  /' Emission angle for prompt neutrons with very low E_kin revised (06/June/2019) KHS '/   
  /' P_fis revised: energy-dependent collective enhancement (04/September/2019) KHS '/
  /' Error in calculation of kinematics (causing subscript-range violation) corrected (12/September/2019) KHS '/
  /' Deformation of heavy fragment in fission of nuclei around mercury like
     deformation of light fragments in S1 and S2 in the actinides.
     Deformation of light fragment in fission of nuclei around mercury = 0  
    (From new experimental data of Christelle Schmitt et al., 2019)   (preliminary: 20/December/2019) KHS '/
  /' Data structure for correlation/covariance matrices simplified (02/February/2020) KHS '/  
  /' Initial energy added to name of lmd file in batch mode (02/February/2020) KHS '/  
  /' Option: locally adjusted (=default) or global model parameters in batch mode added (27/February/2020) KHS '/ 
  /' Calculation and output of Chi-square vs. different evaluations and LOHENGRIN data (06/April/2020) KHS '/
  /' List-mode output of state after prompt-gamma emission added (27/April/2020) KHS '/
  /' Correlations and covariances of cumulative yields, also for 2 different systems, implemented (30/April/2020) KHS '/
  /' Filter on specific fission modes introduced (18/July/2020) KHS '/
  /' Nuclear properties for NucProp and DCLbranching extracted from JEFF-3.3 decay file (20/March/2020) Kilian Kern '/
  /' Nuclear properties from JEFF-3.3 included in GEF (26/July/2020) KHS '/
  /' Technical correction: Clearing of spectra for particles and gammas from CN shifted before multi-chance block (09/August/2020) KHS '/ 
  /' More elaborate calculation of threshold for switching on the calculation of multi-chance fission (01/September/2020) KHS '/
  /' Re-organization of the reading of spectroscopic and decay data in DCLbranchingxxx.bas and Nucpropxxx.bas (05/September/2020) KHS '/
  /' Revision of the S4 fission channel (energy dependence from C 102, 054611 (2020)) (04/December/2020) KHS '/
  /' Error messages revised (03/January/2021) KHS '/
  /' Composed level-density formula (const. temp - Fermi gas) exactly matched by adjusted shell in FG regime (20/April/2021) KHS '/
  /' Cumulation process starting from external post-neutron fission yields implemented (16/May/2021) KHS '/
  /' Output of A-dependent gamma multiplicities: extended to N=0 (19/May/2021) KHS '/
  /' More consistent description of S4 (Z around 38) for pre-actinides 
      (dE_Defo_S4 adjusted to mass yields ad low E*) (01/June/2021) KHS '/
  /' T_Rusanov limited in pairing regime (24/Sept/2021) KHS '/
  
  /' FreeBASIC is available from http://www.freebasic.net/ '/
  /' FreeBASIC runs on Windows, Linux, and DOS. '/
  /' FreeBASIC runs also under Wine on MAC OS. '/
  /' FreeBASIC compiles a binary code that uses the C run-time library. '/
     
  
  #Include "utilities.bi"


  /' Functions and subroutines '/
  
   Declare Function _ 
         Getyield(E_rel As Single,E As Single,E_shell As Single, dE_defo As Single, _
                  T_low As Single,T_high As Single,T_high_mac As Single,Imode As Integer) As Single
     	
   Declare Function F1(Z_S_A As Single) As Single
   Declare Function F2(Z_S_A As Single) As Single
   Declare Function Masscurv(Z As Single, A As Single, RL As Single, kappa As Single) As Single
   Declare Function Masscurv1(Z As Single, A As Single, RL As Single, kappa As Single) As Single

   Declare Function De_Saddle_Scission(Z_square_over_Athird As Single, _
           ESHIFTSASCI As Single) As Single

   Declare Function TEgidy(A As Single,DU As Single,Fred As Single) As Single
   
   Declare Function TRusanov(E As Single, A As Single) As Single

   Declare Function LyMass(Z As Single,A As Single,beta As Single) As Single

   Declare Function LyPair(Z As Integer,A As Integer) As Single

   Declare Function TFPair(Z As Integer,A As Integer) As Single

   Declare Function Pmass(Z As Single,A As Single,beta As Single) As Single

   Declare Function FEDEFOLys(Z As Single,A As Single,beta As Single) As Single
   
   Declare Function FEDEFOP(Z As Single,A As Single,beta As Single) As Single

   Declare Function LDMass(Z As Single,A As Single,beta As Single) As Single
   
   Declare Function AME2012(Z As Integer,A As Integer) As Single

   Declare Function U_SHELL(Z As Integer,A As Integer) As Single
   
   Declare Function U_SHELL_exp(Z As Integer, A As Integer) As Single   
   
   Declare Function U_SHELL_EO_exp(Z As Integer, A As Integer) As Single

   Declare Function U_MASS(Z As Single,A As Single) As Single

   Declare Function ECOUL( _
	        Z1 As Single,A1 As Single,beta1 As Single,Z2 As Single,A2 As Single, _
           beta2 As Single,d As Single) As Single

   Declare Function beta_light(Z As Integer,betaL0 As Single,betaL1 As Single) As Single

   Declare Function beta_heavy(Z As Integer,betaH0 As Single,betaH1 As Single) As Single

   Declare Function _
           Z_equi(ZCN As Integer,A1 As Integer,A2 As Integer, _
           beta1 As Single,beta2 As Single,d As Single, Imode As Integer) _
           As Single

   Declare Sub Beta_opt_light(A1 As Single,A2 As Single,Z1 As Single,Z2 As Single, _
             d As Single,beta2_imposed As Single,ByRef beta1_opt As Single)

   Declare Sub Beta_Equi( _
          A1 As Single,A2 As Single,Z1 As Single,Z2 As Single,d As Single, _
          beta1prev As Single,beta2prev As Single, _
          ByRef beta1opt As Single,ByRef beta2opt As Single)

   Declare Function U_Ired(Z As Single,A As Single) As Single

   Declare Function U_IredFF(Z As Single,A As Single) As Single
   
   Declare Function U_I_Shell(Z As Single, A As Single) As Single
   
   Declare Function U_alev_ld(Z As Single, A As Single) As Single
   
   Declare Function U_Temp(Z As Single, A As Single, E As Single, Ishell As Integer, _
             Ipair As Integer, Tscale As Single,Econd As Single, Etrans As Single) As Single

   Declare Function U_Even_Odd(I_Channel As Integer,PEO As Single) As Single
   
   Declare Function BFTF(RZ As Single,RA As Single,I_Switch As Integer) As Single
   Declare Function BFTFA(RZ As Single,RA As Single,I_Switch As Integer) As Single
   Declare Function BFTFB(RZ As Single,RA As Single,I_Switch As Integer) As Single

   Declare Function Gaussintegral(R_x As Single,R_sigma As Single) As Single

   /' Utility functions '/


   Declare Function U_Box(x As Single,sigma As Single, _ 
                  width As Single) As Single
   Declare Function U_Box2(x As Single,sigma1 As Single, sigma2 As Single, _ 
                  width As Single) As Single
   Declare Function U_Gauss(x As Single,sigma As Single) As Single
   Declare Function U_Gauss_abs(x As Single,sigma As Single) As Single
   Declare Function U_Gauss_mod(x As Single,sigma As Single) As Single
   Declare Function U_LinGauss(x As Single,R_Sigma As Single) As Single
   Declare Function Bell(xpos As Single, xleft As Single, xright As Single) As Single

   Declare Function U_Valid(I_Z As Integer,I_A As Integer) As Ubyte
 
   
   Declare Function U_Delta_S0(I_Z As Integer,I_A As Integer) As Single 



/' Internal variables '/
    Const As Single pi = 3.14159
    Dim Shared As Integer I_N_CN /' Neutron number of fissioning nucleus '/
    Dim Shared As Longint I,J,K
    Dim Shared As Single T_coll_Mode_1,T_coll_Mode_2,T_coll_Mode_3,T_coll_Mode_4
    Dim Shared As Single T_asym_Mode_1,T_asym_Mode_2,T_asym_Mode_3,T_asym_Mode_4,T_asym_Mode_0
    Dim Shared As Single Sigpol_Mode_1,Sigpol_Mode_2,Sigpol_Mode_3,Sigpol_Mode_4
    Dim Shared As Single R_Z_Curv_S0,R_Z_Curv1_S0,R_A_Curv1_S0
    Dim Shared As Single ZC_Mode_0,ZC_Mode_1,ZC_Mode_2,ZC_Mode_3,ZC_Mode_4
    Dim Shared As Single ZC_Mode_3_shift
    Dim Shared As Single SigZ_Mode_0,SigZ_Mode_1,SigZ_Mode_2,SigZ_Mode_3,SigZ_Mode_4
    Dim Shared As Single SigZ_SL4
    Dim Shared As Single SN,Sprot
    Dim Shared As Single E_exc_S0_prov,E_exc_S1_prov,E_exc_S2_prov,E_exc_S3_prov,E_exc_S4_prov
    Dim Shared As Single E_exc_S11_prov,E_exc_S22_prov
    Dim Shared As Single E_exc_Barr
    Dim Shared As Single E_LD_S1,E_LD_S2,E_LD_S3,E_LD_S4
    Dim Shared As Single R_Shell_S1_eff,R_Shell_S2_eff,R_Shell_S3_eff,R_Shell_S4_eff
    Dim Shared As Single Yield_Norm
    Dim Shared As Single R_E_exc_eff
    Dim Shared As Single R_Z_Heavy,R_Z_Light
    Dim Shared As Integer I_Mode
    Dim Shared As Single P_selected
    Dim Shared As Integer I_Mode_selected = -1
    Dim Shared As Single T_Pol_Mode_0,T_Pol_Mode_1,T_Pol_Mode_2,T_Pol_Mode_3,T_Pol_Mode_4
    Dim Shared As Single E_Min_Barr
    Dim Shared As Single RI
    Dim Shared As Single rbeta, beta1, beta2
    Dim Shared As Single rbeta_ld, rbeta_shell
    Dim Shared As Single ZUCD
    Dim Shared As Single Z
    Dim Shared As Single E_tunn
    Dim Shared As Single beta1_opt,beta2_opt,beta1_prev,beta2_prev
    Dim Shared As Single Z1,Z2
    Dim Shared As Integer IZ1,IN1,IZ2,IN2
    Dim Shared As Single A1,A2
    Dim Shared As Integer IA1,IA2
    Dim Shared As Single E_defo
    Dim Shared As Single R_Pol_Curv_S0, R_Pol_Curv_S1, R_Pol_Curv_S2,R_Pol_Curv_S3,R_Pol_Curv_S4
    Dim Shared As Single RA,RZ
    Dim Shared As Single SigA_Mode_0, SigA_Mode_1, SigA_Mode_2,SigA_Mode_3,SigA_Mode_4
    Dim Shared As Single AC_Mode_0, AC_Mode_1, AC_Mode_2, AC_Mode_3, AC_Mode_4
    Dim Shared As Single R_A_heavy, R_A_light
    Dim Shared As Single RZpol
    Dim Shared As Single T_intr_Mode_0,T_intr_Mode_1_heavy,T_intr_Mode_1_light
    Dim Shared As Single T_intr_Mode_2_heavy,T_intr_Mode_2_light
    Dim Shared As Single T_intr_Mode_3_heavy,T_intr_Mode_3_light
    Dim Shared As Single T_intr_Mode_4_heavy,T_intr_Mode_4_light
    Dim Shared As Single T
    Dim Shared As Single DU0,DU1,DU2,DU3,DU4
    Dim Shared As Single T_low_S1_used
    Dim Shared As Single SigA_Mode_11,SigA_Mode_22
    Dim Shared As Integer Ngtot = 0
    Dim Shared As Integer Nglight = 0
    Dim Shared As Integer Ngheavy = 0
    Dim Shared As Single Egtot1000 = 0
    Dim Shared As Single S1_enhance, S2_enhance, S1_enhance_S2
    Dim Shared As Single DZ_S2_lowE = 0    
    Dim Shared As Integer I_A_CN,I_Z_CN
    Dim Shared As Single P_I_rms_CN = 0                  /' rms initial angular momentum '/

    ' Model parameters of GEF

    Dim Shared As Single  Emax_valid = 100      /' Maximum allowed excitation energy '/
    Dim As Single Eexc_min_multi = 3            /' Threshold for calc. of multi-chance fission '/
    Dim Shared As Single _Delta_S0 = 0         /' Shell effect for SL, for individual systems '/
    Dim Shared As Single EOscale = 1.0  /' Scaling factor for even-odd structure in yields '/
    Dim Shared As Integer Emode = 1      /' 0: E over BF_B; 1: E over gs; 2: E_neutron; 12: E_proton '/
    Dim Shared As Single D_Par_Fac = 1          /' Scales the variation of perturbed parameters '/
 
    Dim Shared As Single _P_DZ_Mean_S1
    Dim Shared As Single _P_DZ_Mean_S2
    Dim Shared As Single _P_DZ_Mean_S3     /' Shift of mean Z of Mode 3 '/
    Dim Shared As Single _P_DZ_Mean_S4  /' Shell for structure at A around 190 '/
    Dim Shared As Single  ZC_Mode_4L  ' enhances S1  
    Dim Shared As Single _P_Z_Curv_S1
    Dim Shared As Single P_Z_Curvmod_S1    /' Scales energy-dependent shift '/ 
    Dim Shared As Single _P_Z_CurV_S2      
    Dim Shared As Single _S2leftmod     /' Asymmetry in diffuseness of S2 mass peak '/ 
    Dim Shared As Single P_Z_Curvmod_S2    /' Scales energy-dependent shift '/
    Dim Shared As Single _P_A_Width_S2   /' A width of Mode 2 (box) '/
    Dim Shared As Single P_Cut_S2        /' Divide S2 into two modes, S2a and S2b '/
    Dim Shared As Single _P_Z_Curv_S3 
    Dim Shared As Single P_Z_Curvmod_S3    /' Scales energy-dependent shift '/
    Dim Shared As Single P_Z_Curv_SL4
    Dim Shared As Single P_Z_Sigma_SL4 
    Dim Shared As Single _P_Z_Curv_S4
    Dim Shared As Single P_Z_Curvmod_S4   /' Scales energy-dependent shift '/
    Dim Shared As Single _P_Shell_S1     /' Shell effect for Mode 1 (S1) '/
    Dim Shared As Single _P_Shell_S2     /' Shell effect for Mode 2 (S2) '/
    Dim Shared As Single _P_Shell_S3     /' Shell effect for Mode 3 (SA) '/
    Dim Shared As Single P_Shell_SL4    /' Shell enhancing S1 '/
    Dim Shared As Single _P_Shell_S4    /' Shell effect for Mode 4 '/
    Dim Shared As Single P_S4_mod     /' Variation of S4 shell with N_CN (reference: 205Bi) '/
    Dim Shared As Single PZ_S3_olap_pos     /' Pos. of S3 shell in light fragment (in Z) '/
    Dim Shared As Single PZ_S3_olap_curv 
    Dim Shared As Single ETHRESHSUPPS1    
    Dim Shared As Single ESIGSUPPS1      
    Dim Shared As Single Level_S11         /' Level for mode S11 '/
    Dim Shared As Single Shell_fading    /' fading of shell effect with E* '/
    Dim Shared As Single _T_low_S1  
    Dim Shared As Single _T_low_S2       /' Slope parameter for tunneling '/
    Dim Shared As Single _T_low_S3       /' Slope parameter for tunneling '/
    Dim Shared As Single _T_low_S4       /' Slope parameter for tunneling '/
    Dim Shared As Single _T_low_SL       /' Slope parameter for tunneling '/
    Dim Shared As Single T_low_S11      /' Slope parameter for tunneling '/
    Dim Shared As Single _P_att_pol      /' Attenuation length of 132Sn shell '/
    Dim Shared As Single P_att_pol2  
    Dim Shared As Single P_att_pol3 
    Dim Shared As Single _P_att_rel     /' Relative portion of attenuation '/
    Dim Shared As Single dE_Defo_S1     /' Deformation energy expense for Mode 1 '/
    Dim Shared As Single dE_Defo_S2     /' Deformation energy expense for Mode 2 '/
    Dim Shared As Single dE_Defo_S3     /' Deformation energy expense for Mode 3 '/
    Dim Shared As Single dE_Defo_S4     /' Deformation energy expense for Mode 4 '/
    Dim Shared As Single betaL0 
    Dim Shared As Single betaL1 
    Dim Shared As Single betaH0        /' Offset for deformation of heavy fragment '/
    Dim Shared As Single betaH1 
    Dim Shared As Single kappa         /' N/Z dedendence of A-asym. potential '/
    Dim Shared As Single TCOLLFRAC     /' Tcoll per energy gain from saddle to scission '/
    Dim Shared As Single ECOLLFRAC 
    Dim Shared As Single TFCOLL   
    Dim Shared As Single TCOLLMIN 
    Dim Shared As Single ESHIFTSASCI_intr   /' Shift of saddle-scission energy '/ 
    Dim Shared As Single ESHIFTSASCI_coll    /' Shift of saddle-scission energy '/
    Dim Shared As Single EDISSFRAC 
    Dim Shared As Single Epot_shift 
    Dim Shared As Single SIGDEFO   
    Dim Shared As Single SIGDEFO_0 
    Dim Shared As Single SIGDEFO_slope 
    Dim Shared As Single SIGENECK        /' Width of TXE by fluctuation of neck length '/
    Dim Shared As Single EexcSIGrel 
    Dim Shared As Single DNECK             /' Tip distance at scission / fm '/
    Dim Shared As Single FTRUNC50          /' Truncation near Z = 50 '/
    Dim Shared As Single ZTRUNC50          /' Z value for truncation '/
    Dim Shared As Single FTRUNC28          /' Truncation near Z = 28 '/
    Dim Shared As Single ZTRUNC28          /' Z value for truncation '/
    Dim Shared As Single ZMAX_S2           /' Maximum Z of S2 channel in light fragment '/
    Dim Shared As Single NTRANSFEREO       /' Steps for E sorting for even-odd effect '/
    Dim Shared As Single NTRANSFERE        /' Steps for E sorting for energy division '/
    Dim Shared As Single Csort             /' Smoothing of energy sorting '/
    Dim Shared As Single PZ_EO_symm        /' Even-odd effect in Z at symmetry '/
    Dim Shared As Single PN_EO_Symm        /' Even-odd effect in N at symmetry '/
    Dim Shared As Single R_EO_THRESH       /' Threshold for asymmetry-driven even-odd effect'/
    Dim Shared As Single R_EO_SIGMA 
    Dim Shared As Single R_EO_MAX          /' Maximum even-odd effect '/
    Dim Shared As Single _POLARadd         /' Offset for enhanced polarization '/
    Dim Shared As Single POLARfac          /' Enhancement of polarization of ligu. drop '/
    Dim Shared As Single T_POL_RED         /' Reduction of temperature for sigma(Z) '/
    Dim Shared As Single _HOMPOL           /' hbar omega of polarization oscillation '/
    Dim Shared As Single ZPOL1             /' Extra charge polarization of S1 '/
    Dim Shared As Single P_n_x             /' Enhanced inverse neutron x section '/
    Dim Shared As Single Tscale 
    Dim Shared As Single Econd    
    Dim Shared As Single Etrans
    Dim Shared As Single T_orbital         /' From orbital ang. momentum '/
    Dim Shared As Single _Jscaling         /' General scaling of fragment angular momenta '/
    Dim Shared As Single Spin_odd          /' RMS Spin enhancement for odd Z '/ 
                                           /' Value of 0.4 adjusted to data. In conflict with Naik! '/
    Dim Shared As Single Esort_extend      /' Extension of energy range for E-sorting '/
    Dim Shared As Single Esort_slope       /' Onset of E-sorting around symmetry '/     
    Dim Shared As Single Esort_slope_S0    /' Onset of E-sorting around symmetry for S0 channel '/     
     
    #include "Parameters.bas"

  /' I. Properties of nuclide distributions '/

    ReDim Shared Beta(-1 To 6,1 To 2,150) As Single 
       ' -1: microscopic; 0: macroscopic for S0 fission channel

    ReDim Shared Edefo(-1 To 4,1 To 2,150) As Single

    ReDim Shared Zmean(0 To 4,1 To 2,350) As Single

    ReDim Shared Zshift(0 To 4,1 To 2,350) As Single

    ReDim Shared Temp(0 To 4,1 To 2,350) As Single

    ReDim Shared TempFF(0 To 4,1 To 2,350) As Single

    ReDim Shared Eshell(0 To 4,1 To 2,350) As Single

    ReDim Shared PEOZ(0 To 6,1 To 2,350) As Single

    ReDim Shared PEON(0 To 6,1 To 2,350) As Single   ' pre-neutron evaporation

    ReDim Shared EPART(0 To 6,1 To 2,350) As Single
                               
    Redim Shared SpinRMSNZ(0 To 6,1 To 2,1 To 200,1 To 150) As Single
                               

  /' Masses etc. '/
                               
    ReDim Shared BEldmTF(0 To 203,0 To 136) As Single

    ReDim Shared BEexp(0 To 203,0 To 136) As Single

    Redim Shared DEFOtab(0 To 236,0 To 136) As Single
                               
    ReDim Shared ShellMO(0 To 203,0 To 136) As Single

    ReDim Shared EVOD(0 To 203,0 To 136) As Single


    ReDim Shared NZPRE(0 to 200,0 to 150) As Single 
                               
    ReDim Shared NZMPRE(0 To 6,0 to 200,0 to 150) As Single 
 /' Internal parameters for error analysis: '/
    Dim Shared As Single P_DZ_Mean_S1
    Dim Shared As Single P_DZ_Mean_S2
    Dim Shared As Single P_DZ_Mean_S3
    Dim Shared As Single P_DZ_Mean_S4
    Dim Shared As Single P_Z_Curv_S1
    Dim Shared As Single P_Z_Curv_S2
    Dim Shared As Single S2leftmod
    Dim Shared As Single P_A_Width_S2
    Dim Shared As Single P_Z_Curv_S3
    Dim Shared As Single P_Z_Curv_S4
    Dim Shared As Single Delta_S0
    Dim Shared As Single P_Shell_S1
    Dim Shared As Single P_Shell_S2
    Dim Shared As Single P_Shell_S3
    Dim Shared As Single P_Shell_S4
    Dim Shared As Single T_low_S1
    Dim Shared As Single T_low_S2
    Dim Shared As Single T_low_S3
    Dim Shared As Single T_low_S4
    Dim Shared As Single T_low_SL
    Dim Shared As Single P_att_pol
    Dim Shared As Single P_att_rel
    Dim Shared As Single HOMPOL
    Dim Shared As Single POLARadd  
    Dim Shared As Single Jscaling
    

     
 /' Control parameters: '/
    Dim Shared As Single B_F = 0              /' Fission barrier '/
    Dim Shared As Single B_F_ld = 0           /' Fission barrier, liquid drop '/
    Dim Shared As Single E_B = 0              /' Outer fission barrier '/
    Dim Shared As Single E_B_ld = 0           /' Outer fission barrier, liquid drop '/
    Dim Shared As Single R_E_exc_Eb = 0       /' Energy above outer barrier '/
    Dim Shared As Single R_E_exc_GS = 0       /' Energy above ground state '/
    Dim Shared As Single P_Z_Mean_S0 = 0      /' Mean Z of Mode 1 '/
    Dim Shared As Single P_Z_Mean_S1 = 52.8   /' Mean Z of Mode 1 '/
    Dim Shared As Single P_Z_Mean_S2 = 55     /' Mean Z of Mode 2 '/
    Dim Shared As Single P_Z_Mean_S3 = 65     /' Mean Z of Mode 3 '/
    Dim Shared As Single P_Z_Mean_S4 = 42.05  /' Mean Z of Mode 4 '/
    Dim Shared As Single NC_Mode_0 = 0        /' Mean N of symm. Mode '/
    Dim Shared As Single NC_Mode_1 = 0        /' Mean N of Mode 1 '/
    Dim Shared As Single NC_Mode_2 = 0        /' Mean N of Mode 2 '/
    Dim Shared As Single NC_Mode_3 = 0        /' Mean N of Mode 3 '/
    Dim Shared As Single NC_Mode_4 = 0
    Dim Shared As Single B_S1 = 0             /' Barrier S1, relative to SL '/
    Dim Shared As Single B_S2 = 0             /' Barrier S2, relative to SL '/
    Dim Shared As Single B_S3 = 0             /' Barrier S3, relative to SL '/
    Dim Shared As Single B_S4 = 0
    Dim Shared As Single B_S11 = 0            /' Barrier S11, relative to SL '/
    Dim Shared As Single B_S22 = 0            /' Barrier S22, relative to SL '/
    Dim Shared As Single DES11ZPM = 0         /' Mod. of eff. barrier due to ZPM in overlap '/
    Dim Shared As Single Delta_NZ_Pol = 0      /' Polarization for 132Sn '/
    Dim Shared As Single Yield_Mode_0 = 0     /' Relative yield of SL '/
    Dim Shared As Single Yield_Mode_1 = 0     /' Relative yield of S1 '/
    Dim Shared As Single Yield_Mode_2 = 0     /' Relative yield of S2 '/
    Dim Shared As Single Yield_Mode_3 = 0     /' Relative yield of S3 '/
    Dim Shared As Single Yield_Mode_4 = 0     /' Relative yield of S4 '/
    Dim Shared As Single Yield_Mode_11 = 0    /' Relative yield of S11 '/
    Dim Shared As Single Yield_Mode_22 = 0    /' Relative yield of S22 '/
    Dim Shared As Single P_POL_CURV_S0 = 0    /' Stiffnes in N/Z '/
    Dim Shared As Single T_Coll_Mode_0 = 0    /' Effective collective temperature '/
    Dim Shared As Single E_Exc_S0 = 0         /' Energy over barrier of symmetric channel '/
    Dim Shared As Single E_Exc_S1 = 0         /' Energy over barrier of S1 channel '/
    Dim Shared As Single E_Exc_S2 = 0         /' Energy over barrier of S2 channel '/
    Dim Shared As Single E_Exc_S3 = 0         /' Energy over barrier of S3 channel '/
    Dim Shared As Single E_Exc_S4 = 0         /' Energy over barrier of S4 channel '/
    Dim Shared As Single E_Exc_S11 = 0        /' Energy over barrier of S11 channel '/
    Dim Shared As Single E_Exc_S22 = 0        /' Energy over barrier of S22 channel '/
    Dim Shared As Single E_POT_SCISSION = 0   /' Potential-energy gain saddle-scission '/
    Dim Shared As Single E_diss_Scission = 0  /' Dissipated energy between saddle and scission '/
    Dim Shared As Single EINTR_SCISSION = 0   /' Intrinsic excitation energy at scission '/
    Dim Shared As Single EeffS1 = 0           /' Governs S1 reduction '/
    Dim Shared As Single Sigpol_Mode_0 = 0    /' Width of isobaric Z distribution '/

  #Include Once "BEldmTF.bas"
  
  #Include Once "BEexp.bas"
  
  #Include Once "DEFO.bas"

  #Include Once "ShellMO.bas"
  



Declare Sub GEFSUB(P_Z_CN As Integer, P_A_CN As Integer, P_E_EXC As Single, _
   P_J_CN As Single)
   
GEFSUB(92,236,6.,0.0)

' The following section prints the results of GEFSUB.

/'

Dim As Single Zsum

Print
Print "Z, A, Yield"
For I = 10 To 190
  For J = 10 To 140
    If NZPRE(I,J) > 0.0001 Then
      Print J,I+J,NZPRE(I,J)*200
    End If
  Next
Next 


Print
Print "Z yields"
For J = 10 To 140
  Zsum = 0
  For I = 10 To 190
    Zsum = Zsum + NZpre(I,J)
  Next
  If Zsum > 0.0 Then
    Print J, Zsum * 200
  End If   
Next '/ 


/'
Dim As Single Asum
Print
Print "N yields"
For I = 10 To 140
  Asum = 0
  For J = 10 To 190
    Asum = Asum + NZpre(I,J)
 '   If NZPRE(I,J) > 0.001 Then
 '     Print J,I+J,NZPRE(I,J)*200
 '   End If
  Next
  Print I, Asum * 200
Next   '/

End
  

 Sub GEFSUB(P_Z_CN As Integer, P_A_CN As Integer, P_E_EXC As Single, _
   P_J_CN As Single)
   /' Input parameters: '/
   /' Atomic number, mass number, excitation energy/MeV, spin/h_bar of CN '/
   /' Results are stored in external arrays. '/
   
/'<FO INCLUDE "GEFSUBdcl2.FOR" FO>'/
/' This is the place for the statements of Parameters.FOR '/
   Dim As Integer I_short
   Static As Integer I_E_iso  ' numbered in sequence of increasing energy
   Static As Single Spin_CN  
   Dim As Single Spin_pre_fission
   Dim As Single Spin_gs_light
   Dim As Single Spin_gs_heavy

     /' Shell effects for the symmetric fission channel '/
     _Delta_S0 = U_Delta_S0(P_Z_CN,P_A_CN)   ' default values
     
    ' Use nominal parameter values:
     P_DZ_Mean_S1 = _P_DZ_Mean_S1
     P_DZ_Mean_S2 = _P_DZ_Mean_S2
     P_DZ_Mean_S3 = _P_DZ_Mean_S3
     P_DZ_Mean_S4 = _P_DZ_Mean_S4
     P_Z_Curv_S1 = _P_Z_Curv_S1
     P_Z_Curv_S2 = _P_Z_Curv_S2
     S2leftmod = _S2leftmod
     P_A_Width_S2 = _P_A_Width_S2
     P_Z_Curv_S3 = _P_Z_Curv_S3
     P_Z_Curv_S4 = _P_Z_Curv_S4
     Delta_S0 = _Delta_S0
     P_Shell_S1 = _P_Shell_S1
     P_Shell_S2 = _P_Shell_S2
     P_Shell_S3 = _P_Shell_S3
     P_Shell_S4 = _P_Shell_S4
     T_low_S1 = _T_low_S1
     T_low_S2 = _T_low_S2
     T_low_S3 = _T_low_S3
     T_low_S4 = _T_low_S4
     T_low_SL = _T_low_SL
     P_att_pol = _P_att_pol
     P_att_rel = _P_att_rel
     HOMPOL = _HOMPOL
     POLARadd = _POLARadd
     Jscaling = _Jscaling
  
    Dim As Single R_E_exc_used
    R_E_exc_used = P_E_exc
    I_A_CN = P_A_CN
    I_Z_CN = P_Z_CN

    /' Central Z values of fission modes '/
    
    /' Test of barrier height for compact fission '/
 /'   Dim As Single Fbarr_shell
    Dim As Single Fbarr_macro
    Fbarr_shell = 1.44 * (I_C_CN/2)^2 / (1.4 * 2 * (I_A_CN/2)^(1/3))
    Fbarr_macro = 1.44 * (I_C_CN/2)^2 / (1.4 * 2 * (I_A_CN/2)^(1/3)) '/ 

    /' Fit to positions of fission channels (Boeckstiegel et al., 2008) '/
    /' P_DZ_Mean_S1 and P_DZ_Mean_S2 allow for slight adjustments '/
    Scope
    Dim As Single R_Z_mod, R_A_mod,R_corr2
      R_Z_mod = Csng(I_Z_CN)
      R_A_mod = Csng(I_A_CN)
      R_corr2 = 0.055 * (R_A_mod - R_Z_mod*236/92) 
      
      ' * SL (S0) : *
      ZC_Mode_0 = R_Z_mod * 0.5E0      /' Central Z value of SL mode '/

      ' * S1 : *
      ZC_Mode_1 = (55.8E0 - 54.5E0) / (1.56E0 - 1.50E0) * _
                   (R_Z_mod^1.3E0 / R_A_mod - 1.50E0) + 51.5E0 + P_DZ_Mean_S1 _
                   + R_corr2

      ' * S2: *          
      ZC_Mode_2 = (55.8E0 - 54.5E0) / (1.56E0 - 1.50E0) * _
                   (R_Z_mod^1.3E0 / R_A_mod - 1.50E0) + 54.5E0 + P_DZ_Mean_S2 _
                   + R_corr2
                                    
      ' * S3: * 
'      ZC_Mode_3 = ZC_Mode_2 + 4.5E0 + P_DZ_Mean_S3   

      ZC_Mode_3 = ZC_Mode_2 + 4.87E0 + P_DZ_Mean_S3   
      ZC_Mode_3_shift = - 0.015 * (ZC_Mode_3 - ZC_Mode_0)  

ZC_Mode_3 = ZC_Mode_2 + 5.5E0 + P_DZ_Mean_S3   
ZC_Mode_3_shift = - 0.035 * (ZC_Mode_3 - ZC_Mode_0)  

      ZC_Mode_3 = ZC_Mode_3 + ZC_Mode_3_shift
            ' To account for ZCN-dependent shift of S3 towards minimum of mac. potential
      

       ' * S4: *
  ' Do not delete these lines (,because this is a very good fit!):
  '    ZC_Mode_4 = 38.5 + (I_A_CN-I_Z_CN-110)*0.12 - (I_A_CN-I_Z_CN-110)^2 * 0.009 _
  '                - (I_Z_CN-77)*0.34 + P_DZ_Mean_S4 
           ' assumption: mode position moves with Z and A (adjusted to exp. data
           ' of Itkis and Andreyev et al.
     '  ZC_Mode_4 = - (55.8E0 - 54.5E0) / (1.56E0 - 1.50E0) * _
     '              (R_Z_mod^1.3E0 / I_A_CN - 1.50E0) + 37.5 + P_DZ_Mean_S4  - R_corr2 _
     '                + 0.035 * (I_A_CN- I_Z_CN - 100)   'fits Tl201 (itkis), but not so well Po194,196 (Andreyev) 
            ' corresponding P_DZ_Mean_S4 = -0.5 
       ZC_Mode_4 = 35.5 + Csng(I_A_CN - I_Z_CN - 100) * 0.11 + P_DZ_Mean_S4   ' mean Z of light fragment in Mode 4
   
  ' Print "R_corr2: ",R_corr2                
  ' Print "Mode 2, Z and N:", ZC_Mode_2, ZC_Mode_2 / P_Z_CN * (P_A_CN-P_Z_CN)                
  ' Print "Mode 4, Z and N:", ZC_Mode_4, ZC_Mode_4 / P_Z_CN * (P_A_CN-P_Z_CN) 
  ' sleep                
    End Scope



    I_N_CN = I_A_CN - I_Z_CN
    /' Mean deformation at scission as a function of mass '/
    
    /' Mode 0: liquid drop '/
    beta1_prev = 0.3
    beta2_prev = 0.3
    beta1_opt = beta1_prev
    beta2_opt = beta2_prev
    For I_short = 10 to I_Z_CN - 10
      IZ1 = I_short
      Z1 = Csng(IZ1)
      IZ2 = I_Z_CN - IZ1
      Z2 = Csng(IZ2)
      A1 = Z1 / Csng(I_Z_CN) * Csng(I_A_CN)
      A2 = I_A_CN - A1
      
      ' Deformed shell below Z=50, valid for S0 at low E*
      Beta(-1,1,IZ1) = beta_light(IZ1,betaL0,betaL1) - 0.1  
          ' Lower deformation than S1/S2, because Coulomb repulsion from deformed heavy fragment is weaker.
      Beta(-1,2,IZ2) = beta_light(IZ2,betaL0,betaL1) - 0.1     '          "
      E_defo = Lymass(Z1,A1,Beta(-1,1,IZ1)) - Lymass(Z1,A1,0.0)
      Edefo(-1,1,IZ1) = E_defo
      E_defo = Lymass(Z2,A2,Beta(-1,2,IZ2)) - Lymass(Z2,A2,0.0)
      Edefo(-1,2,IZ2) = E_defo

      Beta_Equi(A1,A2,Z1,Z2,dneck,beta1_prev,beta2_prev,beta1_opt,beta2_opt)

      ' Deformation by macroscopic model, valid for S0 at high E*
'Print "Mode 0, Z1,Z2,beta1,beta2 ";Z1;" ";Z2;" ";beta1_opt,beta2_opt
'Print Z1;" ";Z2;" ";beta1_opt,beta2_opt
      Beta(0,1,IZ1) = beta1_opt /' "light" fragment '/
'      Beta(4,1,IZ1) = beta1_opt
      Beta(0,2,IZ2) = beta2_opt /' "heavy" fragment '/
'      Beta(4,2,IZ2) = beta2_opt
      beta1_prev = beta1_opt
      beta2_prev = beta2_opt
      E_defo = Lymass(Z1,A1,beta1_opt) - Lymass(Z1,A1,0.0)
      Edefo(0,1,IZ1) = E_defo  /' "light" fragment '/
'      Edefo(4,1,IZ1) = E_defo
      E_defo = Lymass(Z2,A2,beta2_opt) - Lymass(Z2,A2,0.0)
      Edefo(0,2,IZ2) = E_defo  /' "heavy" fragment '/
'      Edefo(4,2,IZ2) = E_defo
    Next I_short

    /' Mode 1: deformed shells (light) and spherical (heavy) '/
    For I_short = 10 to  I_Z_CN - 10
      Z1 = Csng(I_short)
      Z2 = Csng(I_Z_CN) - Z1
      A1 = (Z1 - 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      A2 = Csng(I_A_CN) - A1
      If I_Z_CN * 0.5 < ZC_Mode_1 Then
      ' Beta_opt_light(A1,A2,Z1,Z2,dneck,0,rbeta_ld)
        /' nu_mean of Cf requires shells in the light fragment: '/
   '     rbeta = beta_light(I,betaL0,betaL1) - 0.1 
                ' smaller than general deformation of light fragment   
                '        (less neck influence due to spherical heavy fragment)
        rbeta = beta_light(I_short,betaL0,betaL1)        
        If rbeta < 0 Then rbeta = 0
      Else
        rbeta = beta_heavy(I_short,betaH0,betaH1)  ' equal to S2 channel
        if rbeta < 0 Then rbeta = 0
      End If
      Beta(1,1,I_short) = rbeta    /' "light" fragment '/
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(1,1,I_short) = E_defo /' "light" fragment '/
    Next I_short
    
    For I_short = 10 To I_Z_CN - 10
      rbeta = 0
      Beta(1,2,I_short) = rbeta
      Edefo(1,2,I_short) = 0   /' "heavy" fragment (at S1 shell) '/
    Next I_short

    /' Mode 2: deformed shells (light and heavy) '/
    For I_short = 10 to I_Z_CN - 10
      Z1 = Csng(I_short)
      Z2 = Csng(I_Z_CN) - Z1
      A1 = (Z1 - 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      A2 = Csng(I_A_CN) - A1
      If I_Z_CN * 0.5 < ZC_Mode_2 Then
    ' Beta_opt_light(A1,A2,Z1,Z2,dneck,beta_heavy(Z2),rbeta_ld)
        rbeta = beta_light(I_short,betaL0,betaL1)   ' general deformation of light fragment
        If rbeta < 0 Then rbeta = 0  ' negative values replaced by 0
      Else
        rbeta = beta_heavy(I_short,betaH0,betaH1)  ' equal to S2 channel
      End If  
      Beta(2,1,I_short) = rbeta
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(2,1,I_short) = E_defo
    Next I_short
    For I_short = 10 To I_Z_CN - 10
      rbeta = beta_heavy(I_short,betaH0,betaH1)   /' "heavy" fragment (at S2 shell)'/
      If rbeta < 0 Then rbeta = 0  ' negative values replaced by 0  
      Beta(2,2,I_short) = rbeta
      Z1 = Csng(I_short)
      A1 = (Z1 + 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(2,2,I_short) = E_defo
    Next I_short

    /' Mode 3 '/
    For I_short = 10 to I_Z_CN - 10
      Z1 = Csng(I_short)
      Z2 = Csng(I_Z_CN) - Z1
      A1 = (Z1 - 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      A2 = Csng(I_A_CN) - A1
      rbeta = beta_light(I_short,betaL0,betaL1) 
      rbeta = Max(rbeta-0.10,0.0)  /' for low nu-bar of lightest fragments '/
   '  Beta_opt_light(A1,A2,Z1,Z2,dneck,beta_heavy(Z2,betaH0,betaH1),rbeta)  
      Beta(3,1,I_short) = rbeta
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(3,1,I_short) = E_defo
    Next I_short
    For I_short = 10 To I_Z_CN - 10
      rbeta = beta_heavy(I_short,betaH0,betaH1) + 0.3 ' Shift from isotopic distributions of S3 nuclei in 239Pu(nth,f)  
      If rbeta < 0 Then rbeta = 0
      Beta(3,2,I_short) = rbeta
      Z1 = Csng(I_short)
      A1 = (Z1 + 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(3,2,I_short) = E_defo
    Next I_short

    /' Mode 4: (Channel S4, (fissioning nucleus in the Z=80 region), Zfrag around 38 '/
    For I_short = 10 to  I_Z_CN - 10    ' heavy fragment
      Z1 = Csng(I_short)
      A1 = Z1 / Csng(I_Z_CN) * Csng(I_A_CN) /' charge polarization neglected '/
      rbeta = Beta(2,1,I_short)  ' Deformation like the light fragment of S2 in the actinides
      if rbeta < 0 Then rbeta = 0
      Beta(4,1,I_short) = rbeta
      Beta(4,2,I_short) = rbeta
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(4,1,I_short) = E_defo /' light fragment '/
      Edefo(4,2,I_short) = E_defo /' heavy fragment '/
    Next I_short

    /' Mode 5: (Channel ST1 in both fragments) '/
    For I_short = 10 To I_Z_CN - 10
      Z1 = Csng(I_short)
      Z2 = Csng(I_Z_CN) - Z1
      rbeta = Beta(1,2,I_short)
      if rbeta < 0 Then rbeta = 0
      Beta(5,1,Int(Z1)) = rbeta
      Beta(5,2,Int(Z1)) = rbeta
    Next I_short

    /' Mode 6: (Channel ST2 in both fragments) '/
    For I_short = 10 To I_Z_CN - 10
      Z1 = Csng(I_short)
      Z2 = Csng(I_Z_CN) - Z1
      rbeta = Beta(2,2,I_short)
      if rbeta < 0 Then rbeta = 0
      Beta(6,1,Int(Z1)) = rbeta
      Beta(6,2,Int(Z1)) = rbeta
    Next I_short


    /' Mean Z as a function of mass '/

    /' Mode 0 '/
    For I_short = 10 To I_A_CN - 10
      ZUCD = Csng(I_short) / Csng(I_A_CN) * Csng(I_Z_CN)
      beta1 = Beta(0,1,Int(ZUCD + 0.5))
      beta2 = Beta(0,2,Int(I_Z_CN - ZUCD + 0.5))
      Z1 = Z_equi(I_Z_CN,I_short, I_A_CN - I_short, beta1, beta2, dneck,0)
      Zmean(0,1,I_short) = Z1
      Zshift(0,1,I_short) = Z1 - ZUCD
      Zmean(0,2,I_A_CN - I_short) = I_Z_CN - Z1
      Zshift(0,2,I_A_CN - I_short) = ZUCD - Z1
    Next I_short

    /' Mode 1 '/
    For I_short = 10 To I_A_CN - 10
      ZUCD = Csng(I_short) / Csng(I_A_CN) * Csng(I_Z_CN)
      Z = ZUCD + ZPOL1 /' Charge polarisation is considered in a crude way '/
      beta1 = Beta(1,1,CInt(Z)) /' "light" fragment '/
      Z = ZUCD - ZPOL1
      beta2 = Beta(1,2,CInt(I_Z_CN-Z)) /' "heavy" fragment  at S1 shell '/
      If Csng(I_Z_CN) * 0.5 < ZC_Mode_1 Then
        Z1 = Z_equi(I_Z_CN,I_short, I_A_CN - I_short, beta1, beta2, dneck,1) 
        Z1 = Z1 + Polaradd
      Else
        Z1 = Z_equi(I_Z_CN,I_short, I_A_CN - I_short, beta1, beta2, dneck,1)
      End If      
      Z1 = Z1 + ZPOL1  /' Charge polarization by shell '/

      If I_Z_CN - Z1 < 50. And (Csng(I_Z_CN) - Z1) > Z1 Then
        Z1 = Csng(I_Z_CN) - 50.    /' Z of mean heavy fragment not below 50 '/
      EndIf

      Zmean(1,1,I_short) = Z1
      Zshift(1,1,I_short) = Z1 - ZUCD     ' neutron-deficient
      Zmean(1,2,I_A_CN - I_short) = Csng(I_Z_CN) - Z1
      Zshift(1,2,I_A_CN - I_short) = ZUCD - Z1  ' neutron rich at shell
    Next I_short

    /' Mode 2 '/
    For I_short = 10 To I_A_CN - 10
      ZUCD = Csng(I_short) / Csng(I_A_CN) * Csng(I_Z_CN)
      Z = ZUCD /' Charge polarisation is here neglected '/
      beta1 = Beta(2,1,CInt(Z))
      beta2 = Beta(2,2,CInt(I_Z_CN-Z))
      If Csng(I_Z_CN) * 0.5 < ZC_Mode_2 Then
        Z1 = Z_equi(I_Z_CN,I_short, I_A_CN-I_short, beta1, beta2, dneck,2)
        Z1 = Z1 + POLARadd
         ' Polarization caused by N=50 shell (assumption)
        Z1 = Z1 - 0.55 * Bell(Csng(I_short)-Z1,45.0,49.5)
      Else
        Z1 = Z_equi(I_Z_CN,I_short, I_A_CN-I_short, beta1, beta2, dneck,2)
      End If      
      
      Zmean(2,1,I_short) = Z1
      Zshift(2,1,I_short) = Z1 - ZUCD        ' neutron deficient
      Zmean(2,2,I_A_CN - I_short) = Csng(I_Z_CN) - Z1  
      Zshift(2,2,I_A_CN - I_short) = ZUCD - Z1  ' neutron rich at shell
    Next I_short

    /' Mode 3 '/
    For I_short = 10 To I_A_CN - 10
      ZUCD = Csng(I_short) / Csng(I_A_CN) * Csng(I_Z_CN)
      Z = ZUCD /' Charge polarisation is here neglected '/
      beta1 = Beta(3,1,CInt(Z))
      beta2 = Beta(3,2,I_Z_CN-Cint(Z))
      Z1 = Z_equi(I_Z_CN,I_short, I_A_CN - I_short, beta1, beta2, dneck,3)
      Z1 = Z1 + POLARadd 
         ' Polarization caused by N=50 shell (assumption)
      Z1 = Z1 - 0.55 * Bell(Csng(I_short)-Z1,45.0,49.5)
'           POLARadd+0.15,POLARfac)   ' Stronger charge polarization in S3, heavy fragment  '!!! KHS
'           POLARadd+0.4,POLARfac)   ' Stronger charge polarization in S3, heavy fragment
      Zmean(3,1,I_short) = Z1
      Zshift(3,1,I_short) = Z1 - ZUCD
      Zmean(3,2,I_A_CN - I_short) = Csng(I_Z_CN) - Z1
      Zshift(3,2,I_A_CN - I_short) = ZUCD - Z1
    Next I_short

    /' Mode 4 (Charge polarization of heavy fragment assumed to be equal to light fragment in S2 in the actinides) '/
    For I_short = 10 To I_A_CN - 10   ' Loop is over the "second" (heavy) fragment!
      ZUCD = Csng(I_short) / Csng(I_A_CN) * Csng(I_Z_CN)
      Z = ZUCD /' Charge polarisation is here neglected '/
      beta1 = Beta(4,1,CInt(I_Z_CN-Z))   ' light fragment
      beta2 = Beta(4,2,CInt(Z))          ' heavy fragment      
      Z2 = Z_equi(I_Z_CN,I_short, I_A_CN-I_short, beta2, beta1, dneck,4)
      Z2 = Z2 + POLARadd
       ' Polarization caused by N=50 shell (assumption)
   '  Z2 = Z2 - 0.55 * Bell(Csng(I_short)-Z1,45.0,49.5)

      Zmean(4,2,I_short) = Z2
'Print "Z2UCD,Z2",ZUCD,Z2-POLARadd,Z2      
      Zshift(4,2,I_short) = Z2 - ZUCD        ' neutron deficient
      Zmean(4,1,I_A_CN - I_short) = Csng(I_Z_CN) - Z2  
      Zshift(4,1,I_A_CN - I_short) = ZUCD - Z2  ' neutron rich at shell
      
/'
  Print "I","Zshift(2,1,I)",I,Zshift(2,1,I)    
  Print "I","Zshift(2,2,I)",I,Zshift(2,2,I)    
  Print "I","Zshift(4,1,I)",I,Zshift(4,1,I)    
  Print "I","Zshift(4,2,I)",I,Zshift(4,2,I)    
    Next
Sleep '/
    
    Next I_short
'Sleep    


    /' General relations between Z and A of fission channels '/
    ' Mode 0
    RZpol = 0
    For I_short = 1 To 3
      RA = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(0,2,CInt(RA))  ' heavy fragment
    Next I_short
    AC_Mode_0 = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN) /' mean position in mass '/
    NC_Mode_0 = AC_Mode_0 - ZC_Mode_0

    ' Mode 1
    RZpol = 0
    For I_short = 1 To 3
      RA = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(1,2,CInt(RA))  ' heavy fragment
    Next I_short
    AC_Mode_1 = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_1 = AC_Mode_1 - ZC_Mode_1
    
    ' Mode 2
    RZpol = 0
    For I_short = 1 To 3
      RA = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(2,2,CInt(RA)) ' heavy fragment
    Next I_short
    AC_Mode_2 = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_2 = AC_Mode_2 - ZC_Mode_2

    ' Mode 3    
    RZpol = 0
    For I_short = 1 To 3
      RA = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(3,2,CInt(RA))  ' heavy fragment
    Next I_short
    AC_Mode_3 = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_3 = AC_Mode_3 - ZC_Mode_3
 
    ' Mode 4
    RZpol = 0
    For I_short = 1 To 3
      RA = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(4,1,CInt(RA)) ' light fragment
    Next I_short
    AC_Mode_4 = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)  ' light fragment
    NC_Mode_4 = AC_Mode_4 - ZC_Mode_4   ' light fragment

    /' Potential curvatures of fission modes '/

   ' For the width of the mass distribution (potential between saddle and scission):
' Print Spin_pre_fission,  P_I_rms_CN 
    R_Z_Curv_S0 = 8.E0 / Csng(I_Z_CN)^2 * Masscurv(Csng(I_Z_CN), Csng(I_A_CN), Spin_pre_fission, kappa)
   ' For the yields of the fission channels (potential near saddle):
    R_Z_Curv1_S0 = 8.E0 / Csng(I_Z_CN)^2 * Masscurv1(Csng(I_Z_CN), Csng(I_A_CN), 0.0, kappa)
    R_A_Curv1_S0 = 8.E0 / Csng(I_A_CN)^2 * Masscurv1(Csng(I_Z_CN), Csng(I_A_CN), 0.0, kappa)

    /' Energy transformation '/
      Select Case Emode
        Case 0   ' Energy above outer barrier given
          R_E_exc_Eb = R_E_exc_used
          R_E_exc_GS = R_E_exc_used + BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
        Case 1,3,-1   ' Energy above ground state given
          R_E_exc_Eb = R_E_exc_used - BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
          R_E_exc_GS = R_E_exc_used
        Case 2     ' kinetic energy of neutron given (SN = neutron separation energy)
      '    SN = (U_Mass(Csng(I_Z_CN),Csng(I_A_CN-1)) + Lypair(I_Z_CN,I_A_CN-1)) _
      '       -(U_Mass(Csng(I_Z_CN),Csng(I_A_CN)) + Lypair(I_Z_CN,I_A_CN))
      '    R_E_exc_GS = R_E_exc_used + SN 
          SN = AME2012(I_Z_CN,I_A_CN-1) - AME2012(I_Z_CN,I_A_CN)
          R_E_exc_GS = R_E_exc_used * ((P_A_CN-1) / P_A_CN) + SN                                            '           target CN           
          R_E_exc_Eb = R_E_exc_GS - BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
        Case 12     ' kinetic energy of proton given (Sprot = proton separation energy)
      '    Sprot = (U_Mass(Csng(I_Z_CN-1),Csng(I_A_CN-1)) + Lypair(I_Z_CN-1,I_A_CN-1)) _
      '       -(U_Mass(Csng(I_Z_CN),Csng(I_A_CN)) + Lypair(I_Z_CN,I_A_CN))
      '    R_E_exc_GS = R_E_exc_used + Sprot 
          Sprot = AME2012(I_Z_CN-1,I_A_CN-1) - AME2012(I_Z_CN,I_A_CN)
          R_E_exc_GS = R_E_exc_used * ((P_A_CN-1) / P_A_CN) + Sprot    
          R_E_exc_Eb = R_E_exc_GS - BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
        Case 13   ' list of energies from file 
          R_E_exc_Eb = R_E_exc_used - BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
          R_E_exc_GS = R_E_exc_used 
      End Select
   
    /' Fission barriers -> global parameters '/
   
    B_F = BFTF(Csng(I_Z_CN),Csng(I_A_CN),1)   
    B_F_ld = BFTF(Csng(I_Z_CN),Csng(I_A_CN),0)
    E_B = BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)   
    E_B_ld = BFTFB(Csng(I_Z_CN),Csng(I_A_CN),0)


    /' Barriers and excitation energies of the fission modes '/

    E_exc_S0_prov = R_E_exc_Eb

    /' Additional influence of N=82 assumed '/
    Delta_NZ_Pol = 82.E0/50.E0 - Csng(I_N_CN)/Csng(I_Z_CN)
    R_Shell_S1_eff = P_Shell_S1 * (1.0 - P_Att_rel * P_Att_Pol * Abs(Delta_NZ_Pol))
 
 '   R_Shell_S1_eff = P_Shell_S1 * _
 '           max(1.0 - P_att_rel,(1.0 - P_att_rel* _
 '                   ( Abs(Delta_NZ_Pol)/P_Att_Pol  + (Delta_NZ_Pol/P_Att_Pol2)^2 _
 '                   + Abs(Delta_NZ_Pol/P_Att_Pol3)^3)))
 ' Print "4335 "; max(1.0 - P_att_rel,(1.0 - P_att_rel* _
 '                   ( Abs(Delta_NZ_Pol)/P_Att_Pol  + (Delta_NZ_Pol/P_Att_Pol2)^2 _
 '                   + Abs(Delta_NZ_Pol/P_Att_Pol3)^3)))
 ' Print  Abs(Delta_NZ_Pol)/P_Att_Pol, _
 '         (Delta_NZ_Pol/P_Att_Pol2)^2, _
 '        Abs(Delta_NZ_Pol/P_Att_Pol3)^3
'sleep                     
    
    /' In Pu, the Z=50 shell meets Z=44 in the light fragment. '/
    /' A deformed shell at Z=44 is assumed to explain the enhancement _ 
       of the S1 channel around Pu '/
    /' This very same shell automatically produces the double-humped '/
    /' mass distribution in 180Hg '/   
'    S1_enhance = P_Shell_SL4 + _
'            (Csng(I_Z_CN) - ZC_Mode_1 - ZC_Mode_4L)^2 * P_Z_Curv_SL4 
      ' 50 instead of ZC_Mode_1, to eliminate the influenc of the mass 
      '(in agreement with experiment, e.g. 238U(nfast,f) ):
    S1_enhance = P_Shell_SL4 + _
            (Csng(I_Z_CN) - 50.0 - ZC_Mode_4L)^2 * P_Z_Curv_SL4 

 '   S1_enhance = P_Shell_SL4 * _
 '       U_Gauss_abs(Csng(I_Z_CN) - 50.0 - 0.3 - ZC_Mode_4L,P_Z_Sigma_SL4)
'Print "4396: U_Gauss_abs";S1_enhance/P_Shell_SL4,R_SHell_S1_eff
'sleep        

 '   S1_enhance = P_Shell_SL4 + _
 '           (Csng(I_Z_CN) - ZC_Mode_1 - ZC_Mode_4L)^2 * P_Z_Curv_SL4 
    If S1_enhance > 0 Then S1_enhance = 0

   If P_Z_CN = 91 Then S1_enhance = S1_enhance + 0.3
   If P_Z_CN = 90 Then S1_enhance = S1_enhance + 0.6
              
 'Print "4384 "; P_Shell_SL4, U_Gauss(Csng(I_Z_CN) - 50.0 - ZC_Mode_4L,0.3), S1_enhance   
 'sleep

' Print "3933"
' Print "ZC_Mode_1,ZC_Mode_4",ZC_Mode_1,ZC_Mode_4
' Print "Delta-Z S1-S4, S1_enhance",I_Z_CN-ZC_Mode_1 - ZC_Mode_4L, S1_enhance      
' Print "3951"
    R_Shell_S1_eff = R_Shell_S1_eff + S1_enhance
' Print I_Z_CN-ZC_Mode_1-ZC_Mode_4L, S1_enhance,R_Shell_S1_eff

    /' The high TKE of S1 in 242Pu(sf) (and neighbours) is obtained by assuming '/
    /' that the Z=44 shell reduces the deformation of the light fragment. '/
    For I = 10 To I_Z_CN - 10
      Z1 = Csng(I)
      A1 = (Z1 - 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
  '    Beta(1,1,Z1) = Beta(1,1,Z1) + 0.15 * S1_enhance   /' "light" fragment '/
      Beta(1,1,I) = exp(S1_enhance) * Beta(1,1,I) _
                       + (1.E0-exp(S1_enhance)) * (Beta(1,1,I)-0.25)
      Beta(1,1,I) = Max(Beta(1,1,I),0.0)
      E_defo = Lymass(Z1,A1,Beta(1,1,I)) - Lymass(Z1,A1,0.0)
      Edefo(1,1,I) = E_defo /' "light" fragment '/
    Next   

   ' Influence of S2 shell in complementary fragment
   ' May be called "S12 fission channel"
    T_Asym_Mode_2 = 0.5
    SigZ_Mode_2 = Sqr(0.5E0 * T_Asym_Mode_2/(P_Z_Curv_S2))
    SigA_Mode_2 = SigZ_Mode_2 * Csng(I_A_CN) / Csng(I_Z_CN)
    S1_enhance_S2 = P_Shell_S2 * U_Box(Csng(P_A_CN) - AC_Mode_2 - AC_Mode_1, _
             SigA_Mode_2,P_A_Width_S2) *P_A_Width_S2

     If S1_enhance_S2 < 0.01 Then 
 '  Print "S1_enhance_S2 ";S1_enhance_S2  
       R_Shell_S1_eff = R_Shell_S1_eff + S1_enhance_S2
     End If   
  
     R_Shell_S2_eff = P_Shell_S2     
    
    ' Overlap of S3 and shell in light fragment  
    R_Shell_S3_eff = P_Shell_S3 * (1.0 - 0.8* PZ_S3_olap_curv _
         * (Csng(I_Z_CN) - ZC_Mode_3 - PZ_S3_olap_pos)^2)
'  Print "4450 "; P_Shell_S3 * (1.0 - 0.8 * PZ_S3_olap_curv _
'         * (Csng(I_Z_CN) - ZC_Mode_3 - PZ_S3_olap_pos)^2) , ZC_Mode_3 
'  sleep            
 '  R_Shell_S3_eff = -5.605
'        * (Csng(I_Z_CN) - 60.5E0 - PZ_S3_olap_pos)^2)
    R_Shell_S3_eff = Min(R_Shell_S3_eff,0.0)    
    
  ' Additional empirical dependence on N/Z  
' R_Shell_S3_eff = R_Shell_S3_eff - _
'       1 * ( (I_A_CN-I_Z_CN)/I_Z_CN - (236-92)/92)  
'       5 * ( (I_A_CN-I_Z_CN)/I_Z_CN - (236-92)/92)  

    R_Shell_S4_eff = 2.0 * (P_Shell_S4 + P_Z_Curv_S4 * (ZC_Mode_4 - ZC_Mode_0)^2)     
       ' overlap of S4 in both fragments       
    If R_Shell_S4_eff > P_Shell_S4 Then R_Shell_S4_eff = P_Shell_S4 
       ' no overlap at large distance

    E_ld_S1 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_1 - ZC_MODE_0) )^2
    B_S1 = E_ld_S1 + R_Shell_S1_eff
    E_exc_S1_prov = E_Exc_S0_prov - B_S1
    
    E_ld_S2 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_2 - ZC_MODE_0) )^2
    B_S2 = E_ld_S2 + R_Shell_S2_eff
    E_exc_S2_prov = E_Exc_S0_prov - B_S2   

    E_ld_S3 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_3 - ZC_MODE_0) )^2
    B_S3 = E_ld_S3 + R_Shell_S3_eff
    E_exc_S3_prov = E_Exc_S0_prov - B_S3 
 

    If I_A_CN < 220 Then  ' Only here S4 is close enough to symmetry to have a chance
      E_ld_S4 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_4 - ZC_MODE_0) )^2

      R_Shell_S4_eff = R_Shell_S4_eff * (1.0 + P_S4_mod * (Csng(I_A_CN-I_Z_CN) - (112)) ) ' variation with N
    
      B_S4 = E_ld_S4 + R_Shell_S4_eff
      E_exc_S4_prov = E_Exc_S0_prov - B_S4
    Else
      B_S4 = 9999
      E_exc_S4_prov = - 9999  
    End If
    

    /' Mode 11 (overlap of channel 1 in light and heavy fragment '/
    /' Potential depth with respect to liquid-drop potential: B_S11 '/
'    B_S11 = 2.E0 * (R_Shell_S1_eff + De_Defo_S1 _
'             + P_Z_Curv_S1 * (ZC_Mode_1 - ZC_Mode_0)^2 ) - De_Defo_S1 
    B_S11 = 2.E0 * (R_Shell_S1_eff  _
             + P_Z_Curv_S1 * (ZC_Mode_1 - ZC_Mode_0)^2 )  
          ' Sum of S1 shells in both fragments exact at symmetry    
  

' Print "4475 ";R_Shell_S1_eff, B_S11
' Print ZC_Mode_0, ZC_Mode_1, P_Z_Curv_S1 * (ZC_Mode_1 - ZC_Mode_0)^2

    ' If B_S11 (see above) is higher than the shell at symmetry from only one fragment
  '  If B_S11 > R_Shell_S1_eff + P_Z_Curv_S1 * (ZC_Mode_1 - ZC_Mode_0)^2 Then
  '    B_S11 = Min(B_S11,R_Shell_S1_eff + P_Z_Curv_S1 * (ZC_Mode_1 - ZC_Mode_0)^2 )
  '  End If   

    DES11ZPM = 0             
       ' The S1 shells in the two fragments must be rather close to form  one pocket:
    If B_S11 < R_Shell_S1_eff + Level_S11 Then  
        ' Lowering of the zero-point motion grows with the width of the potential pocket:
   '   DES11ZPM = -0.6 * Abs(ZC_Mode_1 - ZC_Mode_0)
      DES11ZPM = -0.8 * Abs(ZC_Mode_1 - ZC_Mode_0)  ' Fits the mass distr. of 258Fm(sf)
    End If 
  
    /' Lowering of effective barrier by lower ZPM due to larger width in
       partial overlap region (shells in light and heavy fragment) '/
 '   DES11ZPM = Level_S11 * Min(Abs(ZC_Mode_1 - ZC_Mode_0),4.E0*P_Z_Curv_S1)
 '   DES11ZPM = -0.2 * Abs(ZC_Mode_1 - ZC_Mode_0)  

 ' Print "4473: "; R_Shell_S1_eff, B_S11, DES11ZPM
 ' Sleep   
 
    B_S11 = B_S11 + DES11ZPM
    
 '  If B_S11 > R_Shell_S1_eff + 0.5E0 Then 
 '   If B_S11 > R_Shell_S1_eff + Level_S11 Then
 '     B_S11 = 100   ' S1 and S11 are exclusive
 '   Else
 '     B_S11 = Min(B_S11,R_Shell_S1_eff)  
 '   End If  
    

    E_exc_S11_prov = E_Exc_S0_prov - B_S11

    /' Mode 22 (overlap of channel 2 in light and heavy fragment '/
    /' Potential depth with respect to liquid-drop potential: B_S22 '/

 '   B_S22 = 2.E0 * (E_ld_S2 + P_Shell_S2) _
 '       + 2.E0 * P_Z_Curv_S2 * (ZC_Mode_2 - ZC_Mode_0)^2   /' Parabola '/
'Print E_ld_S2,P_Shell_S2,P_Z_Curv_S2,ZC_Mode_2,ZC_Mode_0   
    B_S22 = 2.E0 * R_Shell_S2_eff  * _
             U_Box(Csng(P_A_CN)/2.0 - AC_Mode_2, _
             SigA_Mode_2,P_A_Width_S2) * P_A_Width_S2
             ' The integral of U_Box is normalized, not the height! 
'    If Abs((P_A_CN/2.E0) - AC_Mode_2) > P_A_Width_S2 Then B_S22 = 9999   
    If P_A_CN < 226 Then B_S22 = 9999 

    E_exc_S22_prov = E_Exc_S0_prov - B_S22

    E_Min_Barr = Min(0.0,B_S1)
    E_Min_Barr = Min(E_Min_Barr,B_S2)
    E_Min_Barr = Min(E_Min_Barr,B_S3)
    E_Min_Barr = Min(E_Min_Barr,B_S4)
    E_Min_Barr = Min(E_Min_Barr,B_S11)
    E_Min_Barr = Min(E_Min_Barr,B_S22)
    
    /' Energy minus the height of the respective fission saddle '/
    E_exc_S0 = E_exc_S0_prov + E_Min_Barr - Delta_S0
    E_exc_S1 = E_exc_S1_prov + E_Min_Barr
    E_exc_S2 = E_exc_S2_prov + E_Min_Barr
    E_exc_S3 = E_exc_S3_prov + E_Min_Barr
    E_exc_S4 = E_exc_S4_prov + E_Min_Barr
    E_exc_S11 = E_exc_S11_prov + E_Min_Barr
    E_exc_S22 = E_exc_S22_prov + E_Min_Barr
    
    /' Energy above the lowest fission saddle '/
    E_exc_Barr = Max(E_Exc_S0,E_Exc_S1)
    E_exc_Barr = Max(E_exc_Barr,E_Exc_S2)
    E_exc_Barr = Max(E_exc_Barr,E_Exc_S3)
    E_exc_Barr = Max(E_exc_Barr,E_Exc_S4)
    E_exc_Barr = Max(E_exc_Barr,E_exc_S11)
    E_exc_Barr = Max(E_exc_Barr,E_exc_S22)
    

    /' Collective temperature used for calculating the widths
       in mass asymmetry and charge polarization '/

    If E_Exc_S0 < 0 Then E_tunn = -E_Exc_S0 Else E_tunn = 0
    R_E_exc_eff = Max(0.1,E_Exc_S0)
  '  T_Coll_Mode_0 = TFCOLL * R_E_exc_eff + _  /' empirical, replaced by TRusanov '/
    T_Coll_Mode_0 = TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
           Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_0 = Max(T_Coll_Mode_0,0.0)

'Print "4596: De_SS, E_tunn, T_Coll ";De_Saddle_Scission(I_Z_CN^2/I_A_CN^0.3333,ESHIFTSASCI_coll),E_tunn,T_Coll_Mode_0    
    
    /' Temperature description fitting to the empirical systematics of Rusanov et al. '/
    /' Here from Ye. N. Gruzintsev et al., Z. Phys. A 323 (1986) 307 '/    
    /' Empirical description of the nuclear temperature according to the '/
    /' Fermi-gas description. Should be valid at higher excitation energies '/
      Dim As Single T_Rusanov
    T_Rusanov = TRusanov(R_E_exc_eff,Csng(I_A_CN)) 
'Print "Temperatures, (GEF, Total, Rusanov): ", T_Coll_Mode_0, TFCOLL * R_E_exc_eff, T_Rusanov
'Print "R_E_exc_eff ",R_E_exc_eff

    T_Coll_Mode_0 = Max(T_Coll_Mode_0,T_Rusanov)
    /' Transition vom const. temp. to Fermi gas occurs around 20 MeV by MAX function '/
'    T_Pol_Mode_0 = T_Pol_Red * T_Coll_Mode_0

    ' Application of the statistical model, intrinsic temperature at saddle
T_Pol_Mode_0 = U_Temp(0.5 * Csng(I_Z_CN),0.5 *Csng(I_A_CN), R_E_exc_eff, 0, 0, Tscale, Econd, Etrans)
'    T_Asym_Mode_0 = Sqr(T_Coll_Mode_0^2 + (6E0*TCOLLMIN)^2)  
T_Asym_Mode_0 = Sqr(T_Coll_Mode_0^2 + (1.0*TCOLLMIN)^2)  
'Print "4124: T_Coll_Mode_0"; T_Coll_Mode_0
'sleep  

    E_pot_scission = (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
               Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_intr) - E_tunn) + Epot_shift 
    E_diss_Scission = EDISSFRAC * E_pot_scission        
'Print "4054:";EDISSFRAC,E_pot_scission,E_diss_Scission                      

    /' Suppression of S1 fission channel at very low excitation energy at scission '/
    /' The idea behind is that the binding energy at scission is such that the
       scission configuration cannot be reached with the available excitation energy. '/
 '   EeffS1 = Max(E_exc_S1,0.0) + EDISSFRAC * E_pot_scission
 '   EeffS1 = Max(0.0,EeffS1)

' Print "4104", U_Mass(I_Z_CN,I_A_CN); _
'       2 * U_Mass(I_Z_CN/2.0,I_A_CN/2.0) + 1.44*(I_Z_CN/2.0)^2 / _
'               (1.5 * ( (I_A_CN/2)^0.333333 + (I_A_CN/2)^0.333333) + dneck ); EeffS1, _
'        - 2 * U_Mass(I_Z_CN/2.0,I_A_CN/2.0) - 1.44*(I_Z_CN/2.0)^2 / _
'               (1.5 * ( (I_A_CN/2)^0.333333 + (I_A_CN/2)^0.333333) + dneck ) + _
'         + Max(E_exc_S1,0.0) + EDISSFRAC * E_pot_scission _     
'         + U_Mass(I_Z_CN,I_A_CN)           
 '   EeffS1 = - 2 * U_Mass(I_Z_CN/2.0,I_A_CN/2.0) - 1.44*(I_Z_CN/2.0)^2 / _
 '              (1.6 * ( (I_A_CN/2)^0.333333 + (I_A_CN/2)^0.333333) + dneck ) + _
 '          Max(E_exc_S1,0.0) + EDISSFRAC * E_pot_scission _     
 '        + U_Mass(I_Z_CN,I_A_CN)     
 '   If EeffS1 < ETHRESHSUPPS1 Then
 '                + 2.E0 * ESIGSUPPS1 Then 
 '     E_exc_S1 = E_exc_S1 + EeffS1 - ETHRESHSUPPS1
 '        0.5E0 * 1.5 * 12.E0 / Sqr(132.E0) * Gaussintegral(ETHRESHSUPPS1 - EeffS1,ESIGSUPPS1)
''         0.5E0 * 4.E0 * 12.E0 / Sqr(132.E0) * Gaussintegral(ETHRESHSUPPS1 - EeffS1,ESIGSUPPS1)
 '   End If
 '   If EeffS2 < ETHRESHSUPPS1 + 2.E0 * ESIGSUPPS1 Then
 '     E_exc_S1 = E_exc_S1 - _
 '        0.5E0 * 1.5 * 12.E0 / Sqr(132.E0) * Gaussintegral(ETHRESHSUPPS1 - EeffS2,ESIGSUPPS1)
 '        0.5E0 * 4.E0 * 12.E0 / Sqr(132.E0) * Gaussintegral(ETHRESHSUPPS1 - EeffS2,ESIGSUPPS1)
 '   EndIf

    T_low_S1_used = T_low_S1
    
    T_Coll_Mode_1 = TFCOLL * Max(E_exc_S1,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(I_Z_CN^2 / _
          Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_1 = Max(T_Coll_mode_1,0.0)
'    T_Pol_Mode_1 = T_Pol_Red * T_Coll_Mode_1
T_Pol_Mode_1 = T_Pol_Mode_0
    T_Asym_Mode_1 = Sqr(T_Coll_Mode_1^2 + (4.0*TCOLLMIN)^2)  ' TCOLLMIN for ZPM

    T_Coll_Mode_2 = TFCOLL * Max(E_exc_S2,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
          Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_2 = Max(T_Coll_mode_2,0.0)
'    T_Pol_Mode_2 = T_Pol_Red * T_Coll_Mode_2
T_Pol_Mode_2 = T_Pol_Mode_0
'    T_Asym_Mode_2 = Sqr(T_Coll_Mode_2^2 + TCOLLMIN^2)
    T_Asym_Mode_2 = Sqr(T_Coll_Mode_2^2 + 4*TCOLLMIN^2)
    
'    Dim As Single T_Asym_Mode_2_dyn  ' Collective dynamical effect ?  
'    T_Asym_Mode_2_dyn = 0.009 * (I_Z_CN^2/(I_A_CN^0.333333) - 92.0^2/(238^0.333333) )
'    T_Asym_Mode_2 = Sqr(T_Asym_Mode_2^2 + T_Asym_Mode_2_dyn^2)

/'    T_Coll_Mode_3 = TFCOLL * Max(E_exc_S3,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
            Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
Print 4954, TFCOLL * Max(E_exc_S3,0.E0),TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
            Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn),  _
            TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
            Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) ),E_exc_S3, _
            TCOLLFRAC * 0.03 * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
            Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) )^2           
sleep '/  
'T_coll_Mode_3 = 0.2     ' for 239Pu(nth,f)
'T_coll_Mode_3 = 0.7     ' for 252Cf(sf)
' Fit to 239Pu(nth,f) and 252Cf(sf) ( unexpectedly large variation with Z^2/A^(1/3) )
T_Coll_Mode_3 = TFCOLL * Max(E_exc_S3,0.E0) + _ 
            TCOLLFRAC * 0.03 * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
            Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) )^2           
    T_Coll_Mode_3 = Max(T_Coll_mode_3,0.0)
'    T_Pol_Mode_3 = T_Pol_Red * T_Coll_Mode_3
T_Pol_Mode_3 = T_Pol_Mode_0
    T_Asym_Mode_3 = Sqr(T_Coll_Mode_3^2 + TCOLLMIN^2)   '!!!
    '    Dim As Single T_Asym_Mode_3_dyn    
    ' Adjusted to the width of Mode 3 in 252Cf(sf)
    ' May be, this is a collective dynamic effect along the fission path
'    T_Asym_Mode_3_dyn = 0.009 * (I_Z_CN^2/(I_A_CN^0.333333) - 92.0^2/(238^0.333333) )
' T_Asym_Mode_3_dyn = 0   
'    T_Asym_Mode_3 = Max(T_Asym_Mode_3,T_Asym_Mode_3_dyn)
'    T_Asym_Mode_3 = Sqr(T_Asym_Mode_3^2 + T_Asym_Mode_3_dyn^2)
    
'Print "4619: ";T_Coll_Mode_3,TCOLLMIN,T_Asym_Mode_3    
'sleep

    T_Coll_Mode_4 = TFCOLL * Max(E_exc_S4,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _
             Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_4 = Max(T_Coll_mode_4,0.0)
'    T_Pol_Mode_4 = T_Pol_Red * T_Coll_Mode_4
T_Pol_Mode_4 = T_Pol_Mode_0
    T_Asym_Mode_4 = Sqr(T_Coll_Mode_4^2 + 4.0*TCOLLMIN^2)  ' ZPM like S1

    /' Stiffness in polarization '/

    RZ = Csng(I_Z_CN) * 0.5E0
    RA = Csng(I_A_CN) * 0.5E0
    beta1 = Beta(0,1,CInt(RZ))
    beta2 = Beta(0,2,CInt(RZ))
    R_Pol_Curv_S0 = ( LyMass( RZ - 1.E0, RA, beta1 ) + _
             LyMass( RZ + 1.0E0, RA, beta2 ) + _
             LyMass( RZ + 1.0E0, RA, beta1 ) + _
             LyMass( RZ - 1.0E0, RA, beta2 ) + _
             ecoul( RZ - 1.0E0, RA, beta1, _
                    RZ + 1.0E0, RA, beta2, dneck) + _
             ecoul( RZ + 1.0E0, RA, beta1, _
                    RZ - 1.0E0, RA, beta2, dneck) - _
         2.0E0*ecoul( RZ, RA, beta1, RZ, RA, beta2, dneck) - _
         2.0E0*LyMass( RZ, RA, beta1 ) - _
         2.0E0*LyMass( RZ, RA, beta2) ) * 0.5E0

    P_Pol_Curv_S0 = R_Pol_Curv_S0
    
   ' Assumption: stiffenss is dominated (and thus well represented) by the macroscopic potential
    R_Pol_Curv_S1 = R_Pol_Curv_S0
    R_Pol_Curv_S2 = R_Pol_Curv_S0
    R_Pol_Curv_S3 = R_Pol_Curv_S0
    R_Pol_Curv_S4 = R_Pol_Curv_S0



    /' Mean values and standard deviations of fission modes '/
    
    Dim As Single R_E_intr_S1, R_E_intr_S2, R_E_intr_S3   ' intrinsic exc. energies at barrier
    Dim As Single R_E_intr_S4
    ReDim As Single R_Att(6)                              ' attenuation of shell
    ReDim As Single R_Att_Sad(6)     
  '  Dim As Single E_backshift 
  '  E_backshift = -3
  

    SIGZ_Mode_0 = Sqr(0.5E0 * T_Asym_Mode_0/R_Z_Curv_S0)
'Print "5455: SIGZ_Mode_0, T_Asym_Mode_0, R_Z_Curv_S0)";SigZ_Mode_0,T_Asym_Mode_0,R_Z_Curv_S0
'sleep    
    
    If T_Pol_Mode_0 > 1.E-2 Then
      SigPol_Mode_0 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S0 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_0)))
    Else
      SigPol_Mode_0 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S0)
        /' including influence of zero-point motion '/
    Endif

    R_E_intr_S1 = Max(E_Exc_S1+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(1) = exp(-R_E_intr_S1/Shell_fading)
    R_Att(5) = R_Att(1)
    R_Att_Sad(1) = exp(-R_E_intr_S1/Shell_fading)
    R_Att_Sad(5) = R_Att_Sad(1)
    SIGZ_Mode_1 = Sqr(0.5E0 * T_Asym_Mode_1/(P_Z_Curv_S1*Sqr(R_Att(1))))
    If T_Pol_Mode_1 > 1.E-2 Then
      SigPol_Mode_1 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S1 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_1)))
    Else
      SigPol_Mode_1 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S1)
    Endif

    R_E_intr_S2 = Max(E_Exc_S2+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(2) = exp(-R_E_intr_S2/Shell_fading)
    R_Att(6) = R_Att(2)
    R_Att_Sad(2) = exp(-R_E_intr_S2/Shell_fading)
    R_Att_Sad(6) = R_Att_Sad(2)
    SIGZ_Mode_2 = Sqr(0.5E0 * T_Asym_Mode_2/(P_Z_Curv_S2*Sqr(R_Att(2))))
    
    SIGZ_SL4 = Sqr(0.5E0 * T_Asym_Mode_2/(P_Z_Curv_SL4*Sqr(R_Att(2))))
    
    If T_Pol_Mode_2 > 1.E-2 Then
      SigPol_Mode_2 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S2 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_2)))
    Else
      SigPol_Mode_2 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S2)
    End If

    R_E_intr_S3 = Max(E_exc_S3+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(3) = exp(-R_E_intr_S3/Shell_fading)
    R_Att_Sad(3) = exp(-R_E_intr_S3/Shell_fading)
    SIGZ_Mode_3 = Sqr(0.5E0 * T_Asym_Mode_3/(P_Z_Curv_S3*Sqr(R_Att(3))))
    If T_Pol_Mode_3 > 1.E-2 Then
      SigPol_Mode_3 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S3 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_3)))
    Else
      SigPol_Mode_3 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S3)
    End if

    R_E_intr_S4 = Max(E_exc_S4+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(4) = exp(-R_E_intr_S4/Shell_fading)
    R_Att_Sad(4) = exp(-R_E_intr_S4/Shell_fading)
    SIGZ_Mode_4 = Sqr(0.5E0 * T_Asym_Mode_4/(P_Z_Curv_S4*Sqr(R_Att(4))))
    If T_Pol_Mode_4 > 1.E-2 Then
      SigPol_Mode_4 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S4 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_4)))
    Else
      SigPol_Mode_4 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S4)
    End if



    /' Energy-dependent shift of fission channels '/
    Scope
      Dim As Single DZ_S1,DZ_S2,DZ_S3,DZ_S4
   '   Dim As Single EtotS0, EtotS2
      Dim As Single P_Z_Curv_S1_eff
      P_Z_Curv_S1_eff = P_Z_Curv_S1 * P_Z_Curvmod_S1
      Dim AS Single P_Z_Curv_S2_eff
      P_Z_Curv_S2_eff = P_Z_Curv_S2 * P_Z_Curvmod_S2     
      Dim As Single P_Z_Curv_S3_eff
      P_Z_Curv_S3_eff = P_Z_Curv_S3 * P_Z_Curvmod_S3     
      Dim As Single P_Z_Curv_S4_eff
      P_Z_Curv_S4_eff = P_Z_Curv_S4 * P_Z_Curvmod_S4     

      DZ_S1 = ZC_Mode_1 * _
              (P_Z_Curv_S1_eff*R_Att(1) / (R_Z_Curv_S0 + P_Z_Curv_S1_eff*R_Att(1)) _
            - (P_Z_Curv_S1_eff / (R_Z_Curv_S0 + P_Z_Curv_S1_eff) ) )
      DZ_S2 =  ZC_Mode_2 * _
               (P_Z_Curv_S2_eff*R_Att(2) / (R_Z_Curv_S0 + P_Z_Curv_S2_eff*R_Att(2)) _
             - (P_Z_Curv_S2_eff / (R_Z_Curv_S0 + P_Z_Curv_S2_eff) ) )  
      DZ_S3 =  ZC_Mode_3 * _
               (P_Z_Curv_S3_eff*R_Att(3) / (R_Z_Curv_S0 + P_Z_Curv_S3_eff*R_Att(3)) _
             - (P_Z_Curv_S3_eff / (R_Z_Curv_S0 + P_Z_Curv_S3_eff) ) )
      DZ_S4 = Sgn(ZC_Mode_4 - ZC_Mode_0) * ZC_Mode_4 * _
               (P_Z_Curv_S4_eff*R_Att(4) / (R_Z_Curv_S0 + P_Z_Curv_S4_eff*R_Att(4)) _
             - (P_Z_Curv_S4_eff / (R_Z_Curv_S0 + P_Z_Curv_S4_eff) ) )  
 
     ' Empirical shift of S2 channel at low excitation energy at scission 
     ' for better reproduction of 238U(s,f) and some data for Th isotopes.
     ' Does not solve the problem of 229Th(nth,f).    
  '   EtotS2 = Max(E_Exc_S2 + E_diss_Scission,0.0)
  '   If EtotS2 < 5.E0 Then
  '     DZ_S2 = DZ_S2 + (5.E0 - EtotS2) * 0.1
  '   End If             

 '   DZ_S1 = 0
 '   DZ_S2 = 0
 '   DZ_S3 = 0
 '   DZ_S4 = 0
   
      P_Z_Mean_S0 = ZC_Mode_0
      ZC_Mode_1 = ZC_Mode_1 + DZ_S1  
      P_Z_Mean_S1 = ZC_Mode_1          /' Copy to global parameter '/
      ZC_Mode_2 = ZC_Mode_2 + DZ_S2  
      P_Z_Mean_S2 = ZC_Mode_2          /'             "            '/
      ZC_Mode_3 = ZC_Mode_3 + DZ_S3
      P_Z_Mean_S3 = ZC_Mode_3
   '   ZC_Mode_4 = ZC_Mode_4 + DZ_S4  
           ' shift is very small, because S4 exists only close to symmetry
      P_Z_Mean_S4 = ZC_Mode_4 
    End Scope

    /' Energy dependence of charge polarization '/
    /' Due to washing out of shells '/
    
    For I = 10 To I_A_CN - 10   ' mass number
      For J = 1 To 4    ' fission channel
        For K = 1 To 2    ' light - heavy group
          Zshift(J,K,I) = Zshift(0,K,I) + (Zshift(J,K,I) - Zshift(0,K,I))*R_Att(J)
        Next
      Next    
    Next    
    
     
    /' Energy dependence of shell-induced deformation '/
    /' Due to washing out of shells '/
    /' (Under development) '/
  /'For I = 10 To I_Z_CN - 10  ' mass number
      For J = 1 To 4           ' fission channel
        For K = 1 To 2         ' light - heavy group
          beta(J,K,I) = beta(0,K,I) + (beta(J,K,I) - beta(0,K,I))*R_Att_Sad(J)
          if beta(J,K,I) < 0 Then 
            beta(J,K,I) = 0
          End If  
          Z1 = I
          Z2 = I_Z_CN - Z1
          A1 = Z1 / Csng(I_Z_CN) * Csng(I_A_CN)
          A2 = I_A_CN - A1
          E_defo = Lymass(Z1,A1,beta(J,K,I)) - Lymass(Z1,A1,0.0)
          Edefo(J,K,I) = E_defo
        Next
      Next    
    Next  '/  
    
    


    /' General relations between Z and A of fission channels '/  
    /' 2nd iteration '/

    RZpol = 0  ' calculations for the heavy fragment
    For I = 1 To 3
      RA = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(0,2,CInt(RA))
    Next
    AC_Mode_0 = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN) /' mean position in mass '/
    NC_Mode_0 = AC_Mode_0 - ZC_Mode_0

    RZpol = 0  ' calculations for the heavy fragment
    For I = 1 To 3
      RA = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(1,2,CInt(RA))
    Next
    AC_Mode_1 = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_1 = AC_Mode_1 - ZC_Mode_1

    RZpol = 0  ' calculations for the heavy fragment
    For I = 1 To 3
      RA = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(2,2,CInt(RA))
    Next
    AC_Mode_2 = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_2 = AC_Mode_2 - ZC_Mode_2
    
    RZpol = 0  ' calculations for the heavy fragment
    For I = 1 To 3
      RA = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(3,2,CInt(RA))
    Next
    AC_Mode_3 = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_3 = AC_Mode_3 - ZC_Mode_3

    RZpol = 0  ' calculations for the light(!!!) fragment 
    For I = 1 To 3
      RA = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(4,1,CInt(RA))
    Next
    AC_Mode_4 = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_4 = AC_Mode_4 - ZC_Mode_4

   /' Yields of the fission modes '/
   
    Yield_Mode_0 = Getyield(E_exc_S0,E_exc_S0,0.0,0.0,T_low_SL,TEgidy(Csng(I_A_CN),0.E0,Tscale), _
                                                         TEgidy(Csng(I_A_CN),0.E0,Tscale),0)

    Yield_Mode_1 = _
          Getyield(E_exc_S1,E_exc_S0,R_Shell_S1_eff+dE_Defo_S1,dE_Defo_S1, _
                                     T_low_S1_used,TEgidy(Csng(I_A_CN),R_Shell_S1_eff + dE_Defo_S1,Tscale), _
                                                   TEgidy(Csng(I_A_CN),0.0,Tscale),1)
                  /'  - Getyield(E_exc_S0 - E_ld_S1,T_low,T_high) '/

    Yield_Mode_2 = _ 
          Getyield(E_exc_S2,E_exc_S0,R_Shell_S2_eff + dE_Defo_S2, dE_Defo_S2,_
                                     T_low_S2,TEgidy(Csng(I_A_CN),R_Shell_S2_eff + dE_Defo_S2,Tscale), _
                                              TEgidy(Csng(I_A_CN),0.0,Tscale),2)
                  /'  - Getyield(E_exc_S0 - E_ld_S2,T_low,T_high) '/
                  
    Yield_Mode_3 = _ 
          Getyield(E_exc_S3,E_exc_S0,R_Shell_S3_eff + dE_Defo_S3, dE_Defo_S3,_
                                     T_low_S3,TEgidy(Csng(I_A_CN),R_Shell_S3_eff + dE_Defo_S3,Tscale), _
                                              TEgidy(Csng(I_A_CN),0.0,Tscale),3)
                  /'  - Getyield(E_exc_S0 - E_ld_S3,T_low,T_high) '/

     Yield_Mode_4 = _
        Getyield(E_exc_S4,E_exc_S0,R_Shell_S4_eff + dE_Defo_S4, dE_Defo_S4,  _
                                 T_low_S4,TEgidy(Csng(I_A_CN),R_Shell_S4_eff + dE_Defo_S4,Tscale), _
                                          TEgidy(Csng(I_A_CN),0.0,Tscale),4)
              /'   - Getyield(E_exc_S0 - E_ld_S4,T_low,T_high) '/ 
                 

    If B_S11 > B_S1 Then 
      Yield_Mode_11 = 0.0
    Else
      Yield_Mode_11 = _ 
        Getyield(E_exc_S11,E_exc_S0, T_low_S11, R_Shell_S1_eff + 2 * dE_Defo_S1, 2 * dE_Defo_S1, _
                                                TEgidy(Csng(I_A_CN),R_Shell_S1_eff + 2.E0 * dE_Defo_S1,Tscale), _
                                                TEgidy(Csng(I_A_CN),0.0,Tscale),11)
    End If      

    If B_S22 > B_S2 Then 
      Yield_Mode_22 = 0.0
    Else
      Yield_Mode_22 = _
        Getyield(E_exc_S22,E_exc_S0, T_low_S2, R_Shell_S2_eff,0.0, _
                                               TEgidy(Csng(I_A_CN),R_Shell_S2_eff,Tscale), _
                                               TEgidy(Csng(I_A_CN),0.0,Tscale),22)
    End If     
    
    Yield_Norm = Yield_Mode_0 + Yield_Mode_1 + Yield_Mode_2 + Yield_Mode_3 _
                 + Yield_Mode_4 + Yield_Mode_11 + Yield_Mode_22
    Yield_Mode_0 = Yield_Mode_0 / Yield_Norm
    Yield_Mode_1 = Yield_Mode_1 / Yield_Norm
    Yield_Mode_2 = Yield_Mode_2 / Yield_Norm
    Yield_Mode_3 = Yield_Mode_3 / Yield_Norm
    Yield_Mode_4 = Yield_Mode_4 / Yield_Norm
    Yield_Mode_11 = Yield_Mode_11 / Yield_Norm
    Yield_Mode_22 = Yield_Mode_22 / Yield_Norm
    
    P_selected = 1.0

    Select Case I_Mode_selected
      Case 0
        P_selected = Yield_Mode_0
      Case 1
        P_selected = Yield_Mode_1
      Case 2
        P_selected = Yield_Mode_2
      Case 3
        P_selected = Yield_Mode_3
      Case 4
        P_selected = Yield_Mode_4       
      Case 5
        P_selected = Yield_Mode_11       
      Case 6
        P_selected = Yield_Mode_22       
      Case -1
        P_selected = 1.0
    End Select
    
    If P_selected = 0 Then
      Print "<I> Yield of the selected fission mode too low."
      Print "    No calculation performed."
    End If

    /' Mass widhts of the fission channels '/

    SigA_Mode_0 = SigZ_Mode_0 * Csng(I_A_CN) / Csng(I_Z_CN) /' width in mass '/
    SigA_Mode_1 = SigZ_Mode_1 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_1 = Min(SigA_Mode_1,SigA_Mode_0)  ' not broader than liquid-drop
    SigA_Mode_2 = SigZ_Mode_2 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_2 = Min(SigA_Mode_2,SigA_Mode_0)  ' not broader than liquid-drop
    SigA_Mode_3 = SigZ_Mode_3 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_3 = Min(SigA_Mode_3,SigA_Mode_0)
    SigA_Mode_4 = SigZ_mode_4 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_4 = Min(SigA_Mode_4,SigA_Mode_0)
    SigA_Mode_11 = SigZ_Mode_1 * sqr(2.E0) * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_11 = Min(SigA_Mode_11,SigA_Mode_0)
    SigA_Mode_22 = SigZ_Mode_2 * sqr(2.E0) * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_22 = Min(SigA_Mode_22,SigA_Mode_0)



    /' Shell effects of different fission channels '/
    /' This is the "real" microscopic shell effect, not the effective shell-correction energy '/
    /' EShell acts on the level density and determines the T parameter '/

    For I = 1 To I_A_CN - 1
      For J = 0 To 4
        EShell(J,1,I) = 0   /' Shells in "light" fragment assumed to be zero '/
      Next
      DU0 = 0
      EShell(0,2,I) = 0 /' Shell = 0 in symmetric mode '/

      DU1 = R_Shell_S1_eff + dE_Defo_S1 /' + R_A_Curv1_S1 * (AC_Mode_1 - Float(I,6))**2; '/
      DU1 = MIN(DU1,0.E0)  /' Technical limit '/
      EShell(1,2,I) = DU1

      DU2 = R_Shell_S2_eff + dE_Defo_S2 /' + R_A_Curv1_S2 * (AC_Mode_2 - Float(I,6))**2; '/
      DU2 = Min(DU2,0.E0)  /' Technical limit '/
      EShell(2,2,I) = DU2

      DU3 = R_Shell_S3_eff + dE_Defo_S3 /' + R_A_Curv1_S3 * (AC_Mode_3 - Float(I,6))**2; '/
      DU3 = Min(DU3,0.E0)  /' Technical limit '/
      EShell(3,2,I) = DU3

      DU4 = R_Shell_S4_eff + dE_Defo_S4 /' + R_A_Curv1_S4 * (AC_Mode_4 - Float(I,6))**2; '/
      DU4 = Min(DU4,0.E0)  /' Technical limit '/
      EShell(4,2,I) = DU4

    Next


    /' Intrinsic temperatures of fragments at scission '/

    /' Mean values '/
    T_intr_Mode_0 = TEgidy(AC_Mode_0,0.0,0.8)
    T_intr_Mode_1_heavy = TEgidy(AC_Mode_1,R_Shell_S1_eff + dE_Defo_S1,Tscale)
    T_intr_Mode_1_light = TEgidy(Csng(I_A_CN) - AC_Mode_1,0.0,Tscale)
    T_intr_Mode_2_heavy = TEgidy(AC_Mode_2,R_Shell_S2_eff + dE_Defo_S2,Tscale)
    T_intr_Mode_2_light = TEgidy(Csng(I_A_CN) - AC_Mode_2,0.0,Tscale)
    T_intr_Mode_3_heavy = TEgidy(AC_Mode_3,R_Shell_S3_eff + dE_Defo_S3,Tscale)
    T_intr_Mode_3_light = TEgidy(Csng(I_A_CN) - AC_Mode_3,0.0,Tscale)
    T_intr_Mode_4_heavy = TEgidy(AC_Mode_4,R_Shell_S4_eff + dE_Defo_S4,Tscale)
    T_intr_Mode_4_light = TEgidy(Csng(I_A_CN) - AC_Mode_4,0.0,Tscale)


    /' Mass-dependent values of individual fragments '/
    /' Mode 0 '/
    For I = 1 To I_A_CN - 1
      T = TEgidy(Csng(I),EShell(0,1,I),Tscale)
      Temp(0,1,I) = T /' "light" fragment at freeze-out (somewhere before scission) '/
      T = TEgidy(Csng(I),EShell(0,2,I),Tscale)
      Temp(0,2,I) = T /' "heavy" fragment at freeze-out (somewhere before scission) '/

      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(0,1,I) = T       ' FF in their ground state
      TempFF(0,2,I) = T       ' FF in their ground state 
    Next

    /' Mode 1 '/
    For I = 1 To I_A_CN - 1
      T = TEgidy(Csng(I),EShell(1,1,I),Tscale)
      Temp(1,1,I) = T  /' "light" fragment '/
      T = TEgidy(Csng(I),EShell(1,2,I),Tscale)
      Temp(1,2,I) = T  /' "heavy" fragment '/

      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(1,1,I) = T       ' FF in their ground state
      TempFF(1,2,I) = T       ' FF in their ground state
    Next

    /' Mode 2 '/
    For I = 1 To I_A_CN - 1
      T = TEgidy(Csng(I),EShell(2,1,I),Tscale)
      Temp(2,1,I) = T /' "light" fragment '/
      T = TEgidy(Csng(I),EShell(2,2,I),Tscale)
      Temp(2,2,I) = T /' "heavy" fragment '/

   /' The next section is introduced, because energy sorting is not strong enough,
      when shells are only introduced in the heavy fragment.
      Ad hoc assumption: For Mode 2 there are shells in both fragments of about
      equal size. Technically, we neglect the shells in both fragments.
      This has about the same effect for the energy sorting. '/
      T = TEgidy(Csng(I),0.0,Tscale)   ' FF at scssion
      Temp(2,1,I) = T /' "light" fragment '/
      T = TEgidy(Csng(I),0.0,Tscale)   ' FF at scission
      Temp(2,2,I) = T /' "heavy" fragment '/

      T = TEgidy(Csng(I),0.0,1.0)    ' shell effect neglected
      TempFF(2,1,I) = T    ' FFs in their ground state
      TempFF(2,2,I) = T    ' FFs in their ground state
    Next
    
    /' Mode 3 '/
    For I = 1 To I_A_CN -1
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(3,1,I) = T
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(3,2,I) = T
      
      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(3,1,I) = T       ' FF in their ground state
      TempFF(3,2,I) = T       ' FF in their ground state
    Next

    /' Mode 4 '/
    For I = 1 To I_A_CN -1
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(4,1,I) = T
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(4,2,I) = T
      
      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(4,1,I) = T       ' FF in their ground state
      TempFF(4,2,I) = T       ' FF in their ground state
    Next


    /'** Intrinsic excitation energy at saddle and at scission as well as   **'/
    /'** Even-odd effect in proton and neutron number for each fission mode **'/
    Dim As Single Etot,E1FG,E1ES
    Dim As Single Rincr1P,Rincr1N,Rincr2,Rincr2P,Rincr2N
    Dim As Single T1,T2,E1,E2
    Redim As Single E_coll_saddle(0 To 6)
    Dim As Single Ediff


    For I_Mode = 0 To 6
      E_coll_saddle(I_Mode) = 0
      If I_Mode = 0 Then Etot = E_exc_S0
      If I_Mode = 1 Then Etot = E_exc_S1
      If I_Mode = 2 Then Etot = E_exc_S2
      If I_Mode = 3 Then Etot = E_exc_S3
      If I_Mode = 4 Then Etot = E_exc_S4
      If I_Mode = 5 Then Etot = E_exc_S11
      If I_Mode = 6 Then Etot = E_exc_S22

      If I_Z_CN Mod 2 + I_N_CN Mod 2 = 0 Then  /' Even-even CN '/      
        If Etot > 0 And Etot < 2.E0 * 14.E0/Sqr(Csng(I_A_CN)) Then
          E_coll_saddle(I_Mode) = Etot
          Etot = 0
         /' Excitation below the pairing gap in even-even CN goes into collective excitations '/
        End If
      End If

  '    If I_Z_CN Mod 2 + I_N_CN Mod 2 = 0 Then    ' even-even
  '      Ediff = Min(Etot, 14.0/sqr(Csng(I_A_CN)))
  '    End If
  '    If I_Z_CN Mod 2 + I_N_CN Mod 2 = 1 Then    ' even-odd or odd-even
  '       Ediff = Min(Etot, 2.0 * 14.0/sqr(Csng(I_A_CN)))
  '    End If
  '    Ediff = Max(Ediff,0.0) 
  '    Etot = Etot - Ediff
 
      
      If Etot < 0 Then E_tunn = -Etot Else E_tunn = 0
      Etot = Max(Etot,0.0)
       
      E_pot_scission = (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
               Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_intr) ) 
      E_diss_Scission = EDISSFRAC * (E_pot_scission - E_tunn) + Epot_shift  
      If E_diss_Scission < 0 Then E_diss_Scission = 0
      Etot = Etot + E_diss_Scission
      /' All excitation energy at saddle and part of the potential-energy gain to scission
         go into intrinsic excitation energy at scission '/
 

  

      If I_Mode = 2 Then
        EINTR_SCISSION = Etot /' (For Mode 2) Global parameter '/
      End If

      Dim As Single DT

      For IA1 = 40 To I_A_CN - 40

        IA2 = I_A_CN - IA1
        If I_Mode <= 4 Then
          T1 = Temp(I_Mode,1,IA1)
          T2 = Temp(I_Mode,2,IA2)
        End If
        If I_Mode = 5 Then
          T1 = Temp(1,2,IA1)
          T2 = Temp(1,2,IA2)
        End If  
        If I_Mode = 6 Then
          T1 = Temp(2,2,IA1)
          T2 = Temp(2,2,IA2)
        End If
        DT = ABS(T2 - T1)
        
          /' Even-odd effect '/
        IF I_Z_CN Mod 2 = 0 Then
           Rincr1P = Exp(-Etot/PZ_EO_symm)
        Else
           Rincr1P = 0
        End If
        If I_N_CN Mod 2 = 0 Then
           Rincr1N = Exp(-Etot/PN_EO_symm)
        Else
           Rincr1N = 0
        End If
        PEOZ(I_Mode,1,IA1) = Rincr1P
        PEOZ(I_Mode,2,IA2) = Rincr1P
        PEON(I_Mode,1,IA1) = Rincr1N
        PEON(I_Mode,2,IA2) = Rincr1N

        If Etot > 0 Then
          Rincr2 = Gaussintegral(DT/Etot-R_EO_Thresh, _
                   R_EO_Sigma*(DT+0.0001))
                    /' even-odd effect due to asymmetry '/
        Else   ' even-odd effect is already 100%
          Rincr2 = 0
        End If             
        Rincr2P = (R_EO_MAX - Rincr1P) * Rincr2
        Rincr2N = (R_EO_MAX - Rincr1N) * Rincr2        

        If IA1 <= IA2 Then  ' A1 is lighter or equal to A2
          PEOZ(I_Mode,1,IA1) = _
               PEOZ(I_Mode,1,IA1) + Rincr2P
          IF I_Z_CN Mod 2 = 0 Then
             PEOZ(I_Mode,2,IA2) = _
                PEOZ(I_Mode,2,IA2) + Rincr2P
          Else
             PEOZ(I_Mode,2,IA2) = _
                PEOZ(I_Mode,2,IA2) - Rincr2P
          End if
          PEON(I_Mode,1,IA1) = _
             PEON(I_Mode,1,IA1) + Rincr2N
          IF I_N_CN Mod 2 = 0 Then
             PEON(I_Mode,2,IA2) = _
                PEON(I_Mode,2,IA2) + Rincr2N
          Else
             PEON(I_Mode,2,IA2) = _
                PEON(I_Mode,2,IA2) - Rincr2N
          End if
        Else   
          PEOZ(I_Mode,1,IA1) = PEOZ(I_Mode,2,IA1)
          PEON(I_Mode,1,IA1) = PEON(I_Mode,2,IA1)
          PEOZ(I_Mode,2,IA2) = PEOZ(I_Mode,1,IA2)
          PEON(I_Mode,2,IA2) = PEON(I_Mode,1,IA2)
        End If            
          
          
    /'  Else
          PEOZ(I_Mode,2,IA2) = _
               PEOZ(I_Mode,1,IA2) + Rincr2P
          IF I_Z_CN Mod 2 = 0 Then
             PEOZ(I_Mode,1,IA1) = _
                PEOZ(I_Mode,1,IA1) + Rincr2P
          Else
             PEOZ(I_Mode,1,IA1) = _
                PEOZ(I_Mode,1,IA1) - Rincr2P
          End if
          PEON(I_Mode,2,IA2) = _
             PEON(I_Mode,2,IA2) + Rincr2N
          IF I_N_CN Mod 1 = 0 Then
             PEON(I_Mode,1,IA1) = _
                PEON(I_Mode,1,IA1) + Rincr2N
          Else
             PEON(I_Mode,1,IA1) = _
                PEON(I_Mode,1,IA1) - Rincr2N
          End if
        End If  '/
        
        PEOZ(I_Mode,1,IA1) = PEOZ(I_Mode,1,IA1) * EOscale
        PEOZ(I_Mode,2,IA2) = PEOZ(I_Mode,2,IA2) * EOscale
        PEON(I_Mode,1,IA1) = PEON(I_Mode,1,IA1) * EOscale
        PEON(I_Mode,2,IA2) = PEON(I_Mode,2,IA2) * EOscale


/'  For T1 = 0.5 To 1 Step 0.05
      T2 = 1 - T1
      Print T1,T2, 1.E - Gaussintegral(T2-T1,0.1)
    Next T1
    Sleep  '/

          /' Energy sorting '/
     /' E1 = Etot * Gaussintegral(T2-T1,0.03); '/
        If Abs(T1-T2) < 1.E-6 Then
          E1 = 0.5E0 * Etot
        Else
       '   E1ES = Csort * T1 * T2 / ( Abs(T1 - T2) )
          If I_Mode = 0 Then
            E1ES = Etot * Gaussintegral(T2-T1,Esort_Slope_S0)
          Else
            E1ES = Etot * Gaussintegral(T2-T1,Esort_Slope)
          End If  
          E1ES = Min(E1ES,0.5E0*Etot)
           /' Asymptotic value after "complete" energy sorting '/
          E1FG = Etot * IA1 / I_A_CN  /' in Fermi-gas regime '/
          
          /'  The following section assumes T=const in the superfluid regime
          If Etot < 13 Then E1 = E1ES  ' complete energy sorting
          If Etot >= 13 and Etot <= 20 Then  ' transition region
            E1 = E1ES + (Etot-13)/7*(E1FG-E1ES)
          End If
          If Etot > 20 Then E1 = E1FG   ' Fermi-gas regime   '/
          
          /' The following section extends energy sorting to higher energies '/
          If Etot < 13 * Esort_extend Then E1 = E1ES  ' complete energy sorting
          If Etot >= 13 * Esort_extend and Etot <= 20 * Esort_extend Then  ' transition region
            E1 = E1ES + (Etot-13 * Esort_extend)/7*(E1FG-E1ES)
          End If
          If Etot > 20 * Esort_extend Then E1 = E1FG   ' Fermi-gas regime   
          
        End If
        E2 = Etot - E1
        EPART(I_Mode,1,IA1) = Max(E1,0.0)  /' Mean E* in light fragment '/
        EPART(I_Mode,2,IA2) = Max(E2,0.0)  /' Mean E* in heavy fragment '/
      Next
    Next

  
   /'** RMS angular momentum of fission fragments **'/
   /' Following Naik et al., EPJ A 31 (2007) 195 and  '/
   /' S. G. Kadmensky, Phys. At. Nucl. 71 (2008) 1193 '/ 

   Scope
    Dim As Single AUCD   /' UCD fragment mass '/
    Dim As Single I_rigid_spher  /' I rigid for spherical shape '/
    Dim As Single I_rigid        /' I rigid for deformed scission shape '/
    Dim As Single I_eff          /' I with reduction due to pairing '/
    Dim As Single alph           /' deformation parameter '/
    Dim As Single E_exc          /' Excitation energy '/
    Dim As Single J_rms          /' rms angular momentum '/
    Spin_CN = P_J_CN
    P_I_rms_CN = P_J_CN
    Spin_pre_fission = SPIN_CN  ' target or CN ground-state spin
    
    For IZ1 = 10 To I_Z_CN - 10
      AUCD = Int(Csng(IZ1) * Csng(I_A_CN) / Csng(I_Z_CN))
      For IA1 = Int(AUCD - 15) To Int(AUCD + 15)
       IN1 = IA1 - IZ1
       If IA1 - IZ1 >= 10 Then
        /' Rigid momentum of inertia for spherical nucleus '/
        I_rigid_spher = 1.16E0^2 * Csng(IA1)^1.6667E0 / 103.8415E0
                /' unit: hbar^2/MeV '/
        For I_Mode = 0 To 6  
          
          /' First (normally light) fission fragment: '/
          
          beta1 = Beta(I_Mode,1,IZ1)
          alph = beta1 / sqr(4.E0 * pi / 5.E0)
          I_rigid = I_rigid_spher * (1.E0 + 0.5E0*alph + 9.E0/7.E0*alph^2)
                  /' From Hasse & Myers, Geometrical Relationships ... '/
          E_exc = EPART(I_Mode,1,IA1)
          If E_exc < 0 Then E_exc = 0
          T = U_Temp(Csng(IZ1),Csng(IA1),E_exc,1,1,Tscale,Econd,Etrans)          
       '   T = sqr(T^2 + 0.8^2)       ' For ZPM
       '   T = T_orbital
       '   T =  sqr(T^2 + T_orbital^2)
          If T_orbital > 0.1 Then
            T = T_orbital / tanh(T_orbital/T)  ' T_orbital represents the ZPM
          End If  
          I_eff = I_rigid * (1.E0 - 0.8E0 * exp(-0.693E0 * E_exc / 5.E0))  'Nucl. Phys. A 263 (1976) 141
          J_rms = sqr(2.E0 * I_eff * T)  
          
          J_rms = J_rms * Jscaling 

          If IZ1 Mod 2 = 1 Or IN1 Mod 2 = 1 Then _ 
              J_rms = J_rms + Spin_odd * (Csng(IA1)/140.0)^0.66667 
       '                * Max(0,1 - (E_exc-1)/9) /' empirical '/
           /' Additional angular momentum of unpaired proton. '/ 
           /' See also Tomar et al., Pramana 68 (2007) 111 '/
           
' Print Z1,I_Mode,beta1,T,E_exc,Spin_CN         
' Print " ",I_rigid_spher,I_rigid,I_eff,J_rms

          J_rms = sqr(J_rms^2 + (IA1/I_A_CN * Spin_pre_fission)^2)
            
          SpinRMSNZ(I_Mode,1,IA1-IZ1,IZ1) = J_rms
          
    '     Print
    '     Print IA1,T,E_exc,I_rigid_spher,I_rigid,I_eff,J_rms

          /' Second (normally heavy) fission fragment: '/

          beta2 = Beta(I_Mode,2,IZ1)
          alph = beta2 / sqr(4.E0 * pi / 5.E0)
          I_rigid = I_rigid_spher * (1.E0 + 0.5E0*alph + 9.E0/7.E0*alph^2)
                  /' From Hasse & Myers, Geometrical Relationships ... '/
          E_exc = EPART(I_Mode,2,IA1)
          If E_exc < 0 Then E_exc = 0
          T = U_Temp(Csng(IZ1),Csng(IA1),E_exc,1,1,Tscale,Econd,Etrans)          
      '    T = sqr(T^2 + 0.8^2)       ' For ZPM
      '    T = T_orbital
      '    T =  sqr(T^2 + T_orbital^2)
          If T_orbital > 0.1 Then
            T = T_orbital / tanh(T_orbital/T)  ' T_orbital represents the ZPM
          End If
          I_eff = I_rigid * (1.E0 - 0.8E0 * exp(-0.693E0 * E_exc / 5.E0))
          J_rms = sqr(2.E0 * I_eff * T)

          J_rms = J_rms * Jscaling 

          If IZ1 Mod 2 = 1 Or IN1 Mod 2 = 1 Then _ 
              J_rms = J_rms + Spin_odd * (Csng(IA1)/140.0)^0.66667  
      '                 * Max(0,1 - (E_exc-1)/9) /' empirical '/
           /' Additional angular momentum of unpaired proton. '/ 
           /' See also Tomar et al., Pramana 68 (2007) 111 '/
           
          J_rms = sqr(J_rms^2 + (IA1/I_A_CN * Spin_pre_fission)^2)
          
          SpinRMSNZ(I_Mode,2,IA1-IZ1,IZ1) = J_rms
          
   '      Print IA1,T,E_exc,I_rigid_spher,I_rigid,I_eff,J_rms          

        Next
       ENd If 
      Next
    Next
   End Scope

' ****************************************************************
' *** Filling arrays with results in the folding mode (GEFSUB) *** 
' ****************************************************************
 Scope
 Dim As Integer J_short,K_short
 Dim As Integer Ic, Jc
 Dim As Single R_Help,Zs,R_Sum
 
 For I_short = 10 To I_A_CN - P_Z_CN - 10
   For J_short = 10 To P_Z_CN - 10
     For K_short = 0 To 6
       NZMPRE(K_short,I_short,J_short) = 0.0
     Next K_short
   Next J_short
 Next I_short
 
 ' Mode 0
 For I_short = 20 To I_A_CN - 20
   Ic = I_A_CN - I_short
   R_Help = Yield_Mode_0 * (U_Gauss_mod(AC_Mode_0 - Csng(I_short), SigA_Mode_0) _ 
                 + U_Gauss_mod(AC_Mode_0 - Csng(Ic), SigA_Mode_0)) ' Mass yield
   If I_short < Ic Then
     Zs = ZShift(0,1,I_short)
   Else
     Zs = -ZShift(0,1,Ic)
   End If
   For J_short = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J_short
     If I_short-J_short >= 0 And Ic-Jc >= 0 And I_short-J_short <= 200 _
          And Ic-Jc <= 200 Then
       NZMPRE(0,I_short-J_short,J_short) = R_Help * _ 
          U_Gauss_mod(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I_short) + Zs - _
           Csng(J_short),SigPol_Mode_0) * _
          U_Even_Odd(J_short,PEOZ(0,1,I_short)) * U_Even_Odd(I_short-J_short,PEON(0,1,I_short))   
     End If     
   Next J_short
 Next I_short

 ' Mode 1
 For I_short = 20 To I_A_CN - 20
   Ic = I_A_CN - I_short
   R_Help = Yield_Mode_1 * (U_Gauss_mod(AC_Mode_1 - Csng(I_short), SigA_Mode_1) _
               + U_Gauss_mod(AC_Mode_1 - Csng(Ic), SigA_Mode_1)) ' Mass yield
   If I_short < Ic Then
     Zs = ZShift(1,1,I_short)
   Else
     Zs = -ZShift(1,1,Ic)
   End If  
   For J_short = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J_short
     If I_short-J_short >= 0 And Ic-Jc >= 0 And I_short-J_short <= 200 And Ic-Jc <= 200 Then
       NZMPRE(1,I_short-J_short,J_short) = R_Help * _ 
          U_Gauss_mod(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I_short) + Zs - Csng(J_short),SigPol_Mode_1)* _
          U_Even_Odd(J_short,PEOZ(1,1,I_short)) * U_Even_Odd(I_short-J_short,PEON(1,1,I_short))   
     End If    
   Next J_short
 Next I_short
 
 ' Mode 2
 Dim As Single R_Cut1, R_Cut2
 For I_short = 20 To I_A_CN - 20
   Ic = I_A_CN - I_short
   R_Help = Yield_Mode_2 * (U_Box2(AC_Mode_2 - Csng(I_short), _
               sqr(2.0)*S2leftmod*SigA_Mode_2, _
               sqr(2.0)*SigA_Mode_2,P_A_Width_S2) + _
            U_Box2(AC_Mode_2 - Csng(Ic), _
               sqr(2.0)*S2leftmod*SigA_Mode_2, _
               sqr(2.0)*SigA_Mode_2,P_A_Width_S2))
   If I_short < Ic Then
     Zs = ZShift(2,1,I_short)
   Else
     Zs = -ZShift(2,1,Ic)
   End If   
   For J_short = 10 To P_Z_CN - 10
     Jc = P_Z_CN - J_short 
     If I_short-J_short >= 0 And Ic-Jc >= 0 And I_short-J_short <= 200 And Ic-Jc <= 200 Then
       R_Cut1 = R_Help
       R_Cut2 = R_Help
       If J_short > Jc Then
         R_Cut1 = R_Help * Gaussintegral(Csng(J)-ZTRUNC50,FTRUNC50*SigZ_Mode_2)
       Else 
         R_Cut2 = R_Help * Gaussintegral(Csng(J)-ZTRUNC50,FTRUNC50*SigZ_Mode_2)
       End If     
       NZMPRE(2,I_short-J_short,J_short) = R_Help * _ 
          U_Gauss_mod(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I_short) + Zs - Csng(J_short),SigPol_Mode_2) * _
         U_Even_Odd(J_short,PEOZ(2,1,I_short)) * U_Even_Odd(I_short-J_short,PEON(2,1,I_short))  
     End If     
   Next J_short
 Next I_short

 ' Mode 3
 For I_short = 20 To I_A_CN - 20
   Ic = I_A_CN - I_short
   R_Help = Yield_Mode_3 * (U_Gauss_mod(AC_Mode_3 - Csng(I_short), SigA_Mode_3) + _
                    U_Gauss_mod(AC_Mode_3 - Csng(Ic), SigA_Mode_3)) ' Mass yield   
   If I_short < Ic Then
     Zs = ZShift(3,1,I_short)
   Else
     Zs = -ZShift(3,1,Ic)
   End If   
   For J_short = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J_short
     If I_short-J_short >= 0 And Ic-Jc >= 0 And I_short-J_short <= 200 And Ic-Jc <= 200 Then
       NZMPRE(3,I_short-J_short,J_short) = R_Help * _ 
          U_Gauss_mod(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I_short) + Zs - Csng(J_short),SigPol_Mode_3) * _
         U_Even_Odd(J_short,PEOZ(3,1,I_short)) * U_Even_Odd(I_short-J_short,PEON(3,1,I_short))         
     End If     
   Next J_short
 Next I_short
 
 ' Mode 4
 For I_short = 20 To I_A_CN - 20
   Ic = I_A_CN - I_short
   R_Help = Yield_Mode_4 * (U_Gauss_mod(AC_Mode_4 - Csng(I_short), SigA_Mode_4) + _
                    U_Gauss_mod(AC_Mode_4 - Csng(Ic), SigA_Mode_4))
   If I_short < Ic Then    
     Zs = ZShift(3,1,I_short)   ' light fragment  
   Else
     Zs = -ZShift(3,1,Ic)  ' heavy fragment
   End If   
   For J_short = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J_short
     If I_short-J_short >= 0 And Ic-Jc >= 0 And I_short-J_short <= 200 And Ic-Jc <= 200 Then
       NZMPRE(4,I_short-J_short,J_short) = R_Help * _ 
          U_Gauss_mod(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I_short) + Zs - Csng(J_short),SigPol_Mode_4) * _
          U_Even_Odd(J_short,PEOZ(4,1,I_short)) * U_Even_Odd(I_short-J_short,PEON(4,1,I_short))         
     End If           
   Next J_short
 Next I_short

 ' Mode 11
 For I_short = 20 To I_A_CN - 20
   Ic = I_A_CN - I_short
   R_Help = Yield_Mode_11 * (U_Gauss_mod(AC_Mode_0 - Csng(I_short), SigA_Mode_11) + _
                    U_Gauss_mod(AC_Mode_0 - Csng(Ic), SigA_Mode_11)) ' Mass yield   
   For J_short = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J_short
     If I_short-J_short >= 0 And Ic-Jc >= 0 And I_short-J_short <= 200 And Ic-Jc <= 200 Then
       NZMPRE(5,I_short-J_short,J_short) = R_Help * _ 
          U_Gauss_mod(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I_short) - Csng(J_short),SigPol_Mode_0) * _
          U_Even_Odd(J_short,PEOZ(5,1,I_short)) * U_Even_Odd(I_short-J_short,PEON(5,1,I_short))         
     End If    
   Next J_short
 Next I_short
 
 ' Mode 22
 For I_short = 20 To I_A_CN - 20
   Ic = I_A_CN - I_short
   R_Help = Yield_Mode_22 * (U_Gauss_mod(AC_Mode_0 - Csng(I_short), SigA_Mode_22) + _
                    U_Gauss_mod(AC_Mode_0 - Csng(Ic), SigA_Mode_22)) ' Mass yield   
   For J_short = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J_short
     If I_short-J_short >= 0 And Ic-Jc >= 0 And I_short-J_short <= 200 And Ic-Jc <= 200 Then
       NZMPRE(6,I_short-J_short,J_short) = R_Help * _ 
          U_Gauss_mod(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I_short) - Csng(J_short),SigPol_Mode_0) * _
          U_Even_Odd(J_short,PEOZ(6,1,I_short)) * U_Even_Odd(I_short-J_short,PEON(6,1,I_short))        
     End If            
   Next J_short
 Next I_short
 

 ' Normalization 
 R_Sum = 0
 For I_short = 10 To (I_A_CN - P_Z_CN) - 10
   For J_short = 10 To P_Z_CN - 10
     NZPRE(I_short,J_short) = 0
     For K_short = 0 To 6
       If NZMPRE(K_short,I_short,J_short) > 0 Then
         R_Sum = R_Sum + NZMPRE(K_short,I_short,J_short) 
         NZPRE(I_short,J_short) = NZPRE(I_short,J_short) + NZMPRE(K_short,I_short,J_short)  ' sum of all modes
       End If
     Next K_short
   Next J_short
 Next I_short
 Print R_Sum
 For I_short = 10 To (I_A_CN - P_Z_CN) - 10
   For J_short = 10 To P_Z_CN - 10
     NZPRE(I_short,J_short) = NZPRE(I_short,J_short) / R_Sum
     For K_short = 0 To 6
       NZMPRE(K_short,I_short,J_short) = NZMPRE(K_short,I_short,J_short) / R_Sum
     Next K_short
   Next J_short
 Next I_short
 End Scope
 
 ' Calculate and store distributions of fragment excitation energy and spin
 
 Dim As Integer N_index,Z_index,A_index,M_index 
 Dim As Single Ymin = 1.E-7           ' Minimum yield to be stored
 Dim As Single Eexc_mean, Eexc_sigma
 Dim As Single Eexc_intr, Eexc_coll

 /' ***************** Begin Module GEFRESULTS ********************* '/
 Dim As Integer N_cases            ' Number of cases in NZMkey, Etab, Jtab and Ytab
 ' (First dimension of NZMkey, Etab, Jtab and Ytab)
 ReDim NZMkey(10000,3) As Integer  ' Key (Mode,N,Z) for E*, spin and yield distr. of fragments 
 ReDim Etab(10000,1000) As Single  ' Distribution of E*(exc. energy above yrast line 
    ' of fragments at scission (0.1 MeV bins).
    ' Note that E* = Etab + Erot_fragment with
    '      Erot_fragment =  Jtab * (Jtab + 1) / (2.0 * IfragEff),
    '      IfragEff = U_Ired(I_Z_fragment,I_A_fragment).
    '      Erot and Jtab are correlated!
 Redim Jtab(10000,100) As Single   ' Spin distribution of fragments
 ' (0 to 100 hbar for even-A or 1/2 to 201/2 hbar for odd-A nuclei)
 Redim Ytab(10000) As Single       ' Yield of fragments
 /' ****************** End Module GEFRESULTS ********************* '/
 
  
 N_cases = 0 
 For N_index = 10 To (I_A_CN - P_Z_CN) - 10   ' Neutron number
   For Z_index = 10 To P_Z_CN - 10            ' Atomic number
     For M_index = 0 To 6                     ' Fission channel
       If NZMPRE(M_index,N_index,Z_index) > Ymin Then
         N_cases = N_cases + 1
         If N_cases = Ubound(NZMkey,1) Then
           Print "Upper bound of NZkey reached"
           Print "Result will be incomplete"
           Exit For, For, For 
         End If
         NZMkey(N_cases,1) = M_index  ' Fission mode
         NZMkey(N_cases,2) = N_index  ' Neutron number of fragment
         NZMkey(N_cases,3) = Z_index  ' Atomic number of fragment
       End If
     Next  
   Next
 Next
 Print "N_cases  ",N_cases
 /'<FO WRITE (*,*) "N_cases ",N_cases FO>'/
 
 For K = 1 To N_cases
   M_index = NZMkey(K,1)   ' fission mode
   N_index = NZMkey(K,2)   ' neutron number
   Z_index = NZMkey(K,3)   ' atomic number 
   A_index = N_index + Z_index

   ' Yield
   Ytab(K) = NZMpre(M_index,N_index,Z_index)
   
   ' Angular momentum:
   For I = 1 To 100
     If M_index <= 4 Then
       If Z_index < 0.5 * P_Z_CN Then
         Jtab(K,I) = _
           U_LinGauss(Csng(I),SpinRMSNZ(M_index,1,N_index,Z_index)/sqr(2.0))
       Else
         Jtab(K,I) = _
           U_LinGauss(Csng(I),SpinRMSNZ(M_index,2,N_index,Z_index)/sqr(2.0))
       End If  
     End If
     If M_index = 5 Then
       Jtab(K,I) = _
         U_LinGauss(Csng(I),SpinRMSNZ(1,2,N_index,Z_index)/sqr(2.0))
     End If
     If M_index = 6 Then
       Jtab(K,I) = _
         U_LinGauss(Csng(I),SpinRMSNZ(2,2,N_index,Z_index)/sqr(2.0))
     End If
   Next 
   
   ' Normalize numerically (due to non-continuous values) 
   Scope
     Dim As Single Rint
     Rint = 0
     For I = 1 To 100
       Rint = Rint + Jtab(K,I)
     Next   
     If Rint > 0 Then
       For I = 1 To 100
         Jtab(K,I) = Jtab(K,I) / Rint
       Next  
     End If
   End Scope  
   
   
   ' Excitation energy:
   ' 1. Deformation energy at scission
   Scope
   Dim As Single RS,EtotS0,RW_mac
   If M_index = 0 Then
     EtotS0 = Max(E_Exc_S0 + E_diss_Scission,0.0)
     ' Transition from shell-defined to macroscopic shape with increasing E* 
     ' RW_mac = relative macroscopic influence
     RW_mac = Gaussintegral(EtotS0-20.0,5.0)
     If Z_index < 0.5 * P_Z_CN Then
       Eexc_mean = (1.0 - RW_mac) * Edefo(-1,1,Z_index) + RW_mac * Edefo(0,1,Z_index)
       Eexc_sigma = _
          ( Lymass(Csng(Z_index),Csng(A_index),beta(0,1,Z_index) + SIGDEFO_0) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(0,1,Z_index) ))       
     Else
       Eexc_mean = (1.0 - RW_mac) * Edefo(-1,2,Z_index) + RW_mac * Edefo(0,2,Z_index)
       Eexc_sigma = _ 
          ( Lymass(Csng(Z_index),Csng(A_index),beta(0,2,Z_index) + SIGDEFO_0) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(0,2,Z_index) ))
     End If 
   End If
   If M_index > 0 And M_index <= 4 Then
     If Z_index < 0.5 * P_Z_CN Then
       Eexc_mean = Edefo(M_index,1,Z_index)
   '    RS = SIGDEFO/Sqr(R_Att_Sad(M_index))
       RS = SIGDEFO
       Eexc_sigma = _
          ( Lymass(Csng(Z_index),Csng(A_index),beta(M_index,1,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(M_index,1,Z_index) ))       
     Else
       Eexc_mean = Edefo(M_index,2,Z_index)
   '    RS = SIGDEFO/Sqr(R_Att_Sad(M_index))       
       RS = SIGDEFO       
       Eexc_sigma = _ 
          ( Lymass(Csng(Z_index),Csng(A_index),beta(M_index,2,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(M_index,2,Z_index) ))
     End If
   End If    
   If M_index = 5 Then
     Eexc_mean = Edefo(1,2,Z_index)
   '  RS = SIGDEFO/Sqr(R_Att_Sad(M_index))       
     RS = SIGDEFO       
     Eexc_sigma = _
          ( Lymass(Csng(Z_index),Csng(A_index),beta(1,2,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(1,2,Z_index) ))  
   End If
   If M_index = 6 Then
     Eexc_mean = Edefo(2,2,Z_index)  
   '  RS = SIGDEFO/Sqr(R_Att_Sad(M_index))       
     RS = SIGDEFO       
     Eexc_sigma = _ 
          ( Lymass(Csng(Z_index),Csng(A_index),beta(2,2,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(2,2,Z_index) ))
   End If
   Eexc_mean = Max(Eexc_mean,0.0)
   End Scope
   
   ' 2. Intrinsic excitation energy at scission
   If Z_index < 0.5 * Csng(P_Z_CN) Then   
     Eexc_intr = EPART(M_index,1,A_index)
   Else
     Eexc_intr = EPART(M_index,2,A_index) 
   End If  
   If  M_index = 0 Then  ' add shell and pairing of final fragment
     Eexc_intr = Eexc_intr - _
      AME2012(Z_index,A_index) + LDMass(Csng(Z_index),Csng(A_index),0.) _  
             - 2.0 * 12.0 / sqr(Csng(A_index))     ' general shift  
   End If
   Eexc_intr = Max(Eexc_intr,0.0)
   Eexc_mean = Eexc_mean + Eexc_intr
   Eexc_sigma = sqr(Eexc_sigma^2 + (EexcSIGrel * E_diss_Scission)^2)
   
   ' 3. Pairing staggering
   Eexc_mean = Eexc_mean - Lypair(Z_index,A_index)
   
   ' 4. Collective energy
   Eexc_coll = 0.5 * ECOLLFRAC * (De_Saddle_Scission(Csng(P_Z_CN)^2 / _
     Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn) 
   Eexc_coll = Max(Eexc_coll,0.0)
   Eexc_sigma = sqr(Eexc_sigma^2 + 0.5*(EexcSIGrel*Eexc_coll)^2)
   Eexc_mean = Eexc_mean + Eexc_coll + 0.5 * E_coll_saddle(M_index)

   ' 5. Total excitation energy distribution of fragments (all contributions summed up)
        ' This is the value above the yrast line. Erot must be added!
   For I = 0 To 1000  ' 100 keV bins up to 100 MeV
     Etab(K,I) = exp(-(0.1*Csng(I)-Eexc_mean)^2/(2.0 * Eexc_sigma))
   Next
   
 ' Normalize excitation-energy distribution
   Scope
     Dim As Single RintE 
     RintE = 0
     For I = 0 To 1000
       RintE = RintE + Etab(K,I)
     Next   
     If RintE > 0 Then
       For I = 0 To 1000
         Etab(K,I) = Etab(K,I) / RintE
       Next  
     End If
   End Scope  
   
 Next



  End SUB



  /' Subroutines '/

/'<FO Include "BEexp.FOR" FO>'/
/'<FO Include "BEldmTF.FOR" FO>'/
/'<FO Include "ShellMO.FOR" FO>'/


   Function U_Valid(I_Z As Integer,I_A As Integer) As Ubyte
     Dim As Ubyte Ivalid
     Ivalid = 1
 '   If I_A / I_Z < 210.E0/90.E0 
     If I_A / I_Z < 160.E0 / 76.E0 _
       Or I_A / I_Z > 250.E0/90.E0 _
       Then
       Ivalid = 0
     End If
     If I_Z < 76 Or I_Z > 120 Then
       Ivalid = 0  
     End If
     U_Valid = Ivalid  
' U_Valid = 1
   End Function     


   Function U_Delta_S0(I_Z As Integer,I_A As Integer) As Single
   ' I_Z and I_A refer to the fissioning nucleus
     Dim As Single Delta
     Delta = 0
     
     If I_Z = 89 Then
       If I_A = 226 Then Delta = -0.3
     End If

     If I_Z = 90 Then
       If I_A = 228 Then Delta = 0.2
       If I_A = 229 Then Delta = 0.4
       If I_A = 230 Then Delta = 0.7
       If I_A = 231 Then Delta = 0.8
       If I_A = 232 Then Delta = 0.9
       If I_A = 233 Then Delta = 0.9 
     End If
     
     If I_Z = 92 Then Delta = 0.2    'x
     If I_Z = 92 And I_A = 233 Then Delta = 0.4    'x
     If I_Z = 92 And I_A = 234 Then Delta = 0.4    'x 
          
     If I_Z >= 93 Then Delta = -0.3  'x
     
     U_Delta_S0 = Delta    
   End Function       


  Function Getyield(E_rel As Single,E_ref As Single,E_shell As Single, dE_defo As Single, _
                   T_low As Single,T_high As Single, T_high_mac As Single,I_Mode As Integer) As Single
         /' E_rel: Energy relative to the fission-channel-specific barrier. '/
         /' E_ref: technical quantity, avoids numerical problems. '/
         /' E_shell: microscopic shell effect (washed out at high E*) '/
         /' T_low: Effective temperature below barrier '/
         /' T_high: Effective temperature above barrier '/
         Dim As Single Exp1
         Dim As Single Yield
         Dim As Single E_trans = 8.0 ' Transition energy from CT to FG
         Dim As Single E_backshift = 3 
         Dim As Single F_trans, F_mod
         Dim As Single Rho_mac
         Dim As Single S_mac_CT, S_mac_FG, S_CT, S_FG, S_mac_trans, S_trans, DS_trans, DS

     Exp1 = E_rel/T_low - E_ref/0.4   ' energy far below barrier
                     ' Subtraction of E_ref/0.4 to prevent numerical problems.
     If Exp1 < -50 Then
       Yield = 0
     Else
       Yield = Exp(E_rel / T_high - E_ref/0.4) * 1.E0 / _
          (1.E0 + Exp(-E_rel/ (T_high*T_low/(T_high-T_low) ) ) )
     End If
     ' The following block was an attempt to use a matching Fermi-gas level density
     ' above the critical pairing energy. It is not used, because it was not possible
     ' to match the temperatures (below and above) at the matching energy sufficiently well.
/'     If I_Mode = 4 Then
       If E_rel > E_trans Then
         S_trans = E_trans/T_high            ' const. T entropy (with shell) at transition energy from real g.s.
         S_mac_trans = (E_trans + E_shell)/T_high_mac  ' const. T entropy (without shell) from macrosc. g.s.
         DS_trans = S_trans - S_mac_trans    ' remaining shell effect at transition energy in const. T. regime
                    ' (difference in S = ratio in level density)
         DS = DS_trans _
           * exp(- (E_rel - E_trans) / 18.5 ) _    ' washing out with increasing E*
           * (TRusanov(E_trans+E_shell,I_A_CN) / TRusanov(E_rel+E_shell,I_A_CN) )  

         S_mac_FG = 2 * sqr(0.094 * I_A_CN * (E_rel + E_shell)) _
                      + S_mac_trans - 2 * sqr(0.094 * I_A_CN * (E_trans + E_shell)) _
                      - E_ref/0.4

         S_FG = S_mac_FG + DS
         
'Print "*", DS_trans,DS         
'S_FG = S_mac_FG + DS_trans

' print "*"; E_rel;E_shell;E_backshift       
' print "*";  2 * sqr(0.094 * I_A_CN *(E_rel + E_shell - E_backshift)); _
'              2 * sqr(0.094 * I_A_CN * (E_trans + E_shell - E_backshift));"*" 
' print E_rel;" ";E_shell;T_high;T_high_mac;S_trans;S_mac_trans;DS;DS_trans;S_mac_FG;S_FG; _
'   (TRusanov(E_trans - E_backshift,I_A_CN) / TRusanov(E_rel - E_backshift,I_A_CN) )  
' Print E_backshift;I_A_CN;E_trans;E_shell
' sleep 
 Print "*", Yield, exp(S_FG)
         Yield = exp(S_FG) 
       End If
 '    End If   '/
     Getyield = Max(Yield,0.0)

  End Function


    Function F1(Z_S_A As Single) As Single
      /' Fit to the lower part of the data '/
      Dim As Single Result
      Result = exp(-9.05E0 + 4.58E0 * Log(Z_S_A/2.3E0))
      F1 = Result
    End Function
    Function F2(Z_S_A As Single) As Single
      /' Fit to the upper part of the data '/
      Dim As Single Result
      Result = exp(12.08E0 - 3.27E0 * Log(Z_S_A/2.3E0))
      F2 = Result
    End Function

  Function Masscurv(Z As Single, A As Single, RL As Single, kappa As Single) As Single
     /'  Fit to  Data of Fig. 7 of                                             '/
     /'  "Shell effect in the symmetric-modal fission of pre-actinide nuclei"  '/
     /'  S. I. Mulgin, K.-H. Schmidt, A. Grewe, S. V. Zhdanov                  '/
     /'  Nucl. Phys. A 640 (1998) 375 
     /' (From fit of the width of the mass distributions.) '/                                         '/
    Dim As Single RI, Result1, Result2, Result 
    Dim Z_square_over_A As Single
    Dim ZsqrA As Single
    Dim As Single c_rot = 600.0
    /'<FO REAL*4 F1 FO>'/
    /'<FO REAL*4 F2 FO>'/

    Z_square_over_A = Z^2/A
    RI = (A - 2*Z)/A
    ZsqrA = Z_square_over_A * (1.E0 - kappa * RI^2) / _
       (1.E0 - kappa * ((226.E0 - 2.E0*91.E0)/226.E0)^2) _
        + c_rot * RL^2 / A^(7.0/3.0)  ' Hasse & Myers
 '      + 0.0017 * RL^2

    Result1 = F1(ZsqrA)
    Result2 = F2(ZsqrA)
    Result = Min(Result1,Result2)
    Masscurv = Result
  
  End Function

  Function Masscurv1(Z As Single, A As Single, RL As Single, kappa As Single) As Single
     /'  Fit to  Data of Fig. 7 of                                             '/
     /'  "Shell effect in the symmetric-modal fission of pre-actinide nuclei"  '/
     /'  S. I. Mulgin, K.-H. Schmidt, A. Grewe, S. V. Zhdanov                  '/
     /'  Nucl. Phys. A 640 (1998) 375 
     /' (The left part assumed to be valid for the yields of the fission channels.) '/                                         '/
    Dim As Single RI,Result1, Result2, Result 
'    Dim As Single A,A_central,Z
    Dim Z_square_over_A As Single
    Dim ZsqrA As Single
    Dim As Single c_rot = 600.0
    /'<FO REAL*4 F1 FO>'/
    /'<FO REAL*4 F2 FO>'/

'A_central = -28.8156 + Z * 2.86587  ' Stability line for heavy nuclei        

    Z_square_over_A = Z^2/A
    RI = (A - 2*Z)/A
    ZsqrA = Z_square_over_A * (1.E0 - kappa * RI^2) / _
       (1.E0 - kappa * ((226.E0 - 2.E0*91.E0)/226.E0)^2) _
        + c_rot * RL^2 / A^(7.0/3.0)  ' Hasse & Myers
 '      + 0.0017 * RL^2
 
If ZsqrA < 36.0 Then   ' adjusted to Y(S2) in light nuclei (80<Z<92)
  ZsqrA = ZsqrA + 0.9 * (36.0 - ZsqrA)  
End If 

    Result1 = F1(ZsqrA)
    Result2 = F2(ZsqrA)
  '  Result = Min(Result1,Result2)
    Masscurv1 = Result1
  
  End Function


  Function De_Saddle_Scission(Z_square_over_Athird As Single, _
       ESHIFTSASCI As Single) As Single
    /' Energy release between saddle and scission '/
    /' M. Asghar, R. W. Hasse, J. Physique C 6 (1984) 455 '/
    Dim As Single Result
    Result = (31.E0 - 11.E0) / (1550.E0 - 1300.E0) * _
             (Z_square_over_Athird - 1300.E0 + ESHIFTSASCI) + 11.E0
       ' This formula with ESHIFTSASCI = 0 is the parameterisation of the results
       ' of Ashgar and Hasse, JPC 6 (1984) 455, see 
       ' F. Rejmund, A. V. Ignatyuk, A. R. Junghans, K.-H. Schmidt
       ' Nucl. Phys. A 678 (2000) 215  
    Result = max(Result,0.0)
    De_Saddle_Scission = Result
  End Function


  Function TEgidy(A As Single,DU As Single,Fred As Single) As Single
    /' Temperature parameter of the constant-temperature formula for the
       nuclear level density.
       Input parameters: A = Mass number of nucleus
                         DU = Shell effect (corrected for pairing:P=0 for odd-A nuclei)
       From "Correlations between the nuclear level density parameters"
         Dorel Bucurescu, Till von Egidy
         Phys. Rev. C 72 (2005) 067304    and
            "Systematics of nuclear level density parameters"
         Dorel Bucurescu, Till von Egidy
         J. Phys. G: Nucl. Part. Phys. 31 (2005) S1675 and
            "Systematics of nuclear level density parameters"
         Till von Egidy, Dorel Bucurescu
         Phys. Rev. C 72 (2005) 044311 '/
    Dim As Single Temp_smooth,Temp,T_Fac
  ' Temp_smooth = 17.45E0 / (A^0.666667E0)   
  ' Temp = (17.45E0 - 0.51E0 * DU + 0.051 * DU^2) / (A^0.666667E0)
    Temp_smooth = 1.0 / (0.0570 * A^0.6666667)
    Temp = 1.0 / ( (0.0570 + 0.00193*DU) * A^0.6666667)  ' from  PRC 80 (2009) 054310 
    T_Fac = Temp / Temp_smooth
    Temp = Temp * Fred  /' (For influence of deformation) '/
    TEgidy = Temp
  End Function


  Function TRusanov(E As Single, A As Single) As Single
     /' Fermi-gas level density, parameterisation of Rusanov et al. '/
     Dim As Single Emin = 8  ' critical pairing energy
     Dim As Single Eeff 
       If E < Emin Then 
         Eeff = Emin    ' Introduced Sept. 2021
       Else 
         Eeff = E
       EndIf  
       TRusanov = sqr(E / (0.094E0 * A) )
  End Function

  Function LyMass(Z As Single,A As Single,beta As Single) As Single

     /' liquid-drop mass, Myers & Swiatecki, Lysekil, 1967  '/
     /' pure liquid drop, without pairing and shell effects '/

     /' On input:    Z     nuclear charge of nucleus        '/
     /'              N     number of neutrons in nucleus    '/
     /'              beta  deformation of nucleus           '/
     /' On output:   binding energy of nucleus              '/
 
     /'<FO Const As Single pi = 3.14159 FO>'/
     Dim As Single N
     Dim As Single alpha
     Dim As Single XCOM,XVS,XE,EL

     N = A - Z
     alpha = sqr(5.E0/(4.E0*pi)) * beta
     XCOM = 1.E0 - 1.7826E0 * ((A - 2.E0*Z)/A)^2
            /' factor for asymmetry dependence of surface and volume term '/
     XVS = - XCOM * (15.4941E0*A _
                   - 17.9439E0*A^(2.E0/3.E0)*(1.E0+0.4E0*Alpha^2))
            /' sum of volume and surface energy '/
     XE = Z^2 * (0.7053E0/A^(1.E0/3.E0)*(1.E0-0.2E0*Alpha^2) _
                  - 1.1529E0/A)
     EL = XVS + XE
  /'   EL = EL + LyPair(Z,A); '/
     LyMass = EL
   END Function


   Function LyPair(Z As Integer,A As Integer) As Single
     /' Calculates pairing energy '/
     /' odd-odd nucleus:   Lypair = 0 '/
     /' even-odd nucleus:  Lypair = -12/sqr(A) '/
     /' even-even nucleus: Lypair = -2*12/sqr(A) '/
    Dim As Single E_PAIR

     E_PAIR = - 12.E0 / sqr(Csng(A)) _
          * Csng( ( (Z+1) Mod 2 + (A-Z+1) Mod 2) )

     Lypair = E_PAIR
   END Function


   Function TFPair(Z As Integer,A As Integer) As Single
     /' Pairing energy from Thomas-Fermi model of Myers and Swiatecki '/
     /' Shifted that TFPair is zero for odd-odd nuclei '/
     Dim As Integer N
     Dim As Single E_Pair
     N = A - Z
     IF Z Mod 2 = 0 And N Mod 2 = 0 Then /' even-even '/
        E_Pair = - 4.8E0 / Z^0.333333E0 - 4.8E0 / N^0.333333E0 + 6.6E0 / A^0.666666E0
     EndIf
     If Z Mod 2 = 0 And N Mod 2 = 1 Then /' even Z, odd N '/
        E_Pair = - 4.8E0 / Z^0.333333E0 + 6.6E0 / A^0.666666E0
     EndIf
     If Z Mod 2 = 1 And N Mod 2 = 0 Then /' odd Z, even N '/
        E_Pair = - 4.8E0 / N^0.333333E0 + 6.6E0 / A^0.666666E0
     EndIf
     If Z Mod 2 = 1 And N Mod 2 = 1 Then /' odd N, odd N '/
        E_Pair = 0.0
     EndIf
     TFPair = E_Pair
   End Function


   Function Pmass(Z As Single,A As Single,beta As Single) As Single
    /' Liquid-drop model of Pearson, 2001 '/
     Dim As Single N,EA,BE
     Dim As Single avol = -15.65
     Dim As Single asf = 17.63
     Dim As Single r0 = 1.233
     Dim As Single asym = 27.72
     Dim As Single ass = -25.60
     Dim As Single alpha
     /'<FO Const As Single pi = 3.14159 FO>'/     

      N = A - Z
      alpha = sqr(5.E0/(4.E0*pi)) * beta
      EA = avol + asf * A^(-0.333333)*(1.E0+0.4E0*Alpha^2) _
           + 0.6E0 * 1.44E0 * Z^2 / (A^1.333333 * r0 )*(1.E0-0.2E0*Alpha^2) _
           + (asym + ass * A^(-0.333333)) * (N-Z)^2 / A^2
      BE = EA * A
      Pmass = BE
   End Function


   Function FEDEFOP(Z As Single,A As Single,beta As Single) As Single
     /' According to liquid-drop model of Pearson 2001 '/
      Dim As Single asf = 17.63
      Dim As Single r0 = 1.233
      Dim As Single N,Alpha
     /'<FO Const As Single pi = 3.14159 FO>'/      

      N = A - Z
      alpha = sqr(5.E0/(4.E0*pi)) * beta
      FEDEFOP = asf * A^(0.666667)*(0.4E0*Alpha^2) _
              - 0.6E0 * 1.44E0 * Z^2 / (A^0.333333 * r0 )*(0.2E0*Alpha^2)
   End Function

   
   Function FEDEFOLys(Z As Single,A As Single,beta As Single) As Single
       /'<FO REAL*4 LYMASS FO>'/
       FEDEFOLys = Lymass(Z,A,beta) - Lymass(Z,A,0.0)
   End Function


   Function LDMass(Z As Single,A As Single,beta As Single) As Single
     Dim As Single N,BEtab
     /'<FO REAL*4 LYMASS FO>'/
     /'<FO REAL*4 FEDEFOLYS FO>'/
     /'<FO REAL*4 BEldmTF FO>'/
   '  /'<FO REAL*4 BEexp FO>'/
       N = A - Z
       BEtab = BEldmTF(CInt(N),CInt(Z)) + 2.0 * 12.0 / sqr(Csng(A)) _
                        - 0.00001433*Z^2.39
           ' The values in BEtab are the negative binding energies! 
           ' Pairing in Thomas Fermi masses is zero for Z,N even !        
       If BEtab = 0.0 Then
         BEtab = Lymass(Z,A,0.0) 
         Print "Warning: Binding energy of Z=";Z;", A=";A;" not in mass table,"; _
                        " replaced by LYMASS"
         Print "I_Mode = ";I_Mode               
       End If
       LDMASS = BEtab + FEDEFOLys(Z,A,beta)
   End Function

   Public Function AME2012(IZ As Integer,IA As Integer) As Single
      ' Masses from the 2003 mass evaluation, complemented by TF masses
      ' and Lysekil masses.
      Dim As Single BEexpval
      Dim As Single Z,A,N
      Dim As Integer INeu
      /'<FO REAL*4 LYPAIR FO>'/
      /'<FO REAL*4 U_SHELL FO>'/
      /'<FO REAL*4 LDMASS FO>'/
      /'<FO REAL*4 BEexp FO>'/
      INeu = IA - IZ
      A = Csng(IA)
      Z = Csng(IZ)
      N = A - Z
      BEexpval = BEexp(INeu,IZ) 
      If BEexpval > -1.E10 Then
        AME2012 = BEexpval
      Else
        AME2012 = Ldmass(Z,A,0.0) + U_SHELL(IZ,IA) + Lypair(IZ,IA)
      End If  
   End Function

   Function U_SHELL(Z As Integer,A As Integer) As Single
      Dim As Integer N
      Dim As Single Res
      /'<FO REAL*4 ShellMO FO>'/
      N = A - Z
      Res = ShellMO(N,Z)  
      If Res > 0.0 Then Res = 0.3 * Res     ' KHS (12. Feb. 2012)
     '      ' The positive shell effects for deformed nuclei seem to be too positive
            ' This gives too many high-energetic prompt neutrons.
     U_SHELL = Res
   End Function

   Function U_SHELL_exp(IZ As Integer, IA As Integer) As Single
      Dim Res As Single
      Dim As Single Z,A
      /'<FO REAL*4 LDMASS FO>'/
      /'<FO REAL*4 LYPAIR FO>'/
      /'<FO REAL*4 AME2012 FO>'/
      Z = Csng(IZ)
      A = Csng(IA)
   '   Res = 2.0 * ( AME2012(IZ,IA) - Lypair(IZ,IA) - LDMass(Z,A,0.0) ) _
   '          - 0.25 * ( AME2012(IZ,IA-1) - Lypair(IZ,IA-1) - LDMass(Z,A-1.0,0.0) ) _
   '          - 0.25 * ( AME2012(IZ,IA+1) - Lypair(IZ,IA+1) - LDMass(Z,A+1.0,0.0) ) _
   '          - 0.25 * ( AME2012(IZ+1,IA+1) - Lypair(IZ+1,IA+1) - LDMass(Z+1.0,A+1.0,0.0) ) _
   '          - 0.25 * ( AME2012(IZ-1,IA-1) - Lypair(IZ-1,IA-1) - LDMass(Z-1.0,A-1.0,0.0) )
      Res = 0.5 * ( AME2012(IZ,IA) - Lypair(IZ,IA) - LDMass(Z,A,0.0) ) _
             + 0.125 * ( AME2012(IZ,IA-1) - Lypair(IZ,IA-1) - LDMass(Z,A-1.0,0.0) ) _
             + 0.125 * ( AME2012(IZ,IA+1) - Lypair(IZ,IA+1) - LDMass(Z,A+1.0,0.0) ) _
             + 0.125 * ( AME2012(IZ+1,IA+1) - Lypair(IZ+1,IA+1) - LDMass(Z+1.0,A+1.0,0.0) ) _
             + 0.125 * ( AME2012(IZ-1,IA-1) - Lypair(IZ-1,IA-1) - LDMass(Z-1.0,A-1.0,0.0) )
      U_SHELL_exp = Res             
   End Function

 Function U_SHELL_EO_exp(IZ As Integer, IA As Integer) As Single
     ' Returns experimental shell and even-odd staggering,
     ' just the difference of experimental and macroscopic mass.
      Dim Res As Single
      Dim As Single Z,A
      /'<FO REAL*4 LDMASS FO>'/
      /'<FO REAL*4 LYPAIR FO>'/
      /'<FO REAL*4 AME2012 FO>'/
      Z = Csng(IZ)
      A = Csng(IA)
      Res = AME2012(IZ,IA) - LDMass(Z,A,0.0) 
      U_SHELL_EO_exp = Res             
   End Function



   Function U_MASS(Z As Single,A As Single) As Single
     /' LD + congruence energy + shell (no pairing) '/
     Dim As Single BE
     /'<FO REAL*4 U_SHELL FO>'/
     /'<FO REAL*4 LDMASS FO>'/
     If Z < 0 Or A < 0 Then
       Print "U_Mass: Z, A",Z,A
     End If
     BE = Ldmass(Z,A,0.0)  + U_SHELL(CInt(Z),CInt(A))
  '    BE = AME2012(Cint(Z),Cint(A)) - Lypair(Z,A)
  '    BE = Lymass(Z,A,0.0) + U_Shell(CInt(Z),CInt(A))     
  '    BE = Lymass(Z,A,0.0)  
     U_MASS = BE
   End Function


   Function ECOUL(Z1 As Single,A1 As Single,beta1 As Single,Z2 As Single,A2 As Single, _
                     beta2 As Single,d As Single) _
                     As Single

      /' Coulomb potential between two nuclei                    '/
      /' surfaces are in a distance of d                         '/
      /' in a tip to tip configuration                           '/

      /' approximate formulation                                 '/
      /' On input: Z1      nuclear charge of first nucleus       '/
      /'           A1      mass number of irst nucleus   '/
      /'           beta1   deformation of first nucleus          '/
      /'           Z2      nuclear charge of second nucleus      '/
      /'           A2      mass number of second nucleus  '/
      /'           beta2   deformation of second nucleus         '/
      /'           d       distance of surfaces of the nuclei    '/

       Dim As Single N1,N2,recoul
       Dim As Single dtot
       Dim As Single r0 = 1.16

      N1 = A1 - Z1
      N2 = A2 - Z2
      dtot = r0 *( (Z1+N1)^0.3333333E0 * (1.E0+0.6666667E0*beta1) _
             + (Z2+N2)^0.3333333E0 * (1.E0+0.6666667E0*beta2) ) _
             + d
      REcoul = Z1 * Z2 * 1.44E0 / dtot

      ECOUL = REcoul
   END Function


   Function beta_light(Z As Integer,betaL0 As Single,betaL1 As Single) As Single
      /' Deformation of light fission fragment for S1 and S2 '/
      /' Systematic correlation Z vs. beta for deformed shells '/
      /' Z of fission fragment '/
     Dim As Single beta
     beta = (Z - betaL0) * betaL1/20.E0 
     beta_light = beta
   End Function


   Function beta_heavy(Z As Integer,betaH0 As Single,betaH1 As Single) As Single
      /' Deformation of heavy fission fragment for S2 '/
      /' Systematic correlation Z vs. beta for deformed shells '/
      /' Z of fission fragment '/
     Dim As Single beta
     beta = (Z - betaH0) * betaH1/20.E0 
     beta_heavy = beta
   End Function



   Function Z_equi(ZCN As Integer,A1 As Integer,A2 As Integer, _
           beta1 As Single,beta2 As Single,d As Single,Imode As Integer) _
           As Single
    /' Determines the minimum potential of the scission-point configuration
       represented by two deformed nuclei divided by a tip distance d.
       A1, A2, beta1, beta2, d are fixed, Z1 is searched for and returned on output.  '/

       /' ZCN: Z of fissioning nucleus '/
       /' A1: A of first fission fragment '/
       /' A2: A of second fission fragment '/
       /' beta1: deformation of first fission fragment '/
       /' beta2: deformation of second fission fragment '/
       /' d: tip distance '/

             Dim As Single RZ_equi
             Dim As Single RA1,RA2,RZCN,RACN
             Dim As Single Z1UCD,Z2UCD
             Dim As Single re1,re2,re3,eps1,eps2,DZ_Pol /' help variables '/
             /'<FO REAL*4 ECOUL FO>'/
             /'<FO REAL*4 LYMASS FO>'/

          RA1 = Csng(A1)
          RA2 = Csng(A2)
          RZCN = Csng(ZCN)       
          RACN = RA1 + RA2
          Z1UCD = RA1 / (RA1 + RA2) * RZCN
          Z2UCD = RZCN - Z1UCD
          re1 = LyMass( Z1UCD-1.E0, RA1, beta1 ) + _
                LyMass( Z2UCD+1.E0, RA2, beta2 ) + _
                ECoul( Z1UCD-1.E0, RA1, beta1, _
                       Z2UCD+1.E0, RA2, beta2, d )
          re2 = LyMass( Z1UCD, RA1, beta1) + _
                LyMass( Z2UCD, RA2, beta2) + _
                ECoul( Z1UCD, RA1, beta1, _
                       Z2UCD, RA2, beta2, d )
          re3 = LyMass( Z1UCD+1.E0, RA1, beta1 ) + _
                LyMass( Z2UCD-1.E0, RA2, beta2 ) + _
                ECoul( Z1UCD+1.E0, RA1, beta1, _
                       Z2UCD-1.E0, RA2, beta2, d )
          eps2 = ( re1 - 2.E0*re2 + re3 ) / 2.E0
          eps1 = ( re3 - re1 ) / 2.E0
          DZ_Pol = -eps1 / ( 2.E0 * eps2 )
          
          If DZ_Pol > 2 Or DZ_Pol < -2 Then DZ_Pol = 0

          RZ_equi = Z1UCD + DZ_POL   
          Z_equi = RZ_equi
   End Function


   Sub Beta_opt_light(A1 As Single,A2 As Single,Z1 As Single,Z2 As Single, _
             d As Single,beta2_imposed As Single,ByRef beta1_opt As Single)
    /' Determines the optimum deformation of the light fragment when the deformation of the
       heavy fragment is imposed. '/

       Dim As Single beta1,dbeta1,beta1_prev,beta1_next
       Dim As Single Uguess,Uplus,Uminus,Uprev,Unext
       Dim As Integer I
       /'<FO REAL*4 ECOUL FO>'/
       /'<FO REAL*4 LYMASS FO>'/

    /' List('Beta_opt_light called with ');
       List(A1,A2,Z1,Z2,d,beta2_imposed,beta1_opt);
      DCL Byes Bit(1) aligned;
       Call GPYES('Continue',Byes); '/
       beta1 = 0.5
       dbeta1 = 0.01
       Uguess = LyMass(Z1, A1, beta1) + _
                Lymass(Z2, A2, beta2_imposed) + _
                ECoul(Z1, A1, beta1, Z2, A2, beta2_imposed, d)
       Uplus  = LyMass(Z1, A1, beta1 + dbeta1) + _
                Lymass(Z2, A2, beta2_imposed) + _
                ECoul(Z1, A1, beta1 + dbeta1, Z2, A2, beta2_imposed, d)
       Uminus = LyMass(Z1, A1, beta1 - dbeta1) + _
                Lymass(Z2, A2, beta2_imposed) + _
                ECoul(Z1, A1, beta1 - dbeta1, Z2, A2, beta2_imposed, d)
       If Uplus > Uguess And Uminus > Uguess then
         beta1_opt = beta1
       Else
         If Uplus < Uguess then dbeta1 = 0.01
         If Uminus < Uguess then dbeta1 = -0.01
         Unext = Uguess
         beta1_next = beta1
         For I = 1 to 10000
           beta1_prev = beta1_next
           Uprev = Unext
           beta1_next = beta1_prev + dbeta1
           Unext = LyMass(Z1, A1, beta1_next) + _
                   Lymass(Z2, A2, beta2_imposed) + _
                   ECoul(Z1, A1, beta1_next, Z2, A2, beta2_imposed, d)
           If Unext >= Uprev Then Exit For
         Next
         beta1_opt = beta1_prev
       EndIf

   End Sub


   Sub Beta_Equi(A1 As Single,A2 As Single,Z1 As Single,Z2 As Single,d As Single, _
                  beta1prev As Single,beta2prev As Single, _
                  ByRef beta1opt As Single,ByRef beta2opt As Single)
    /' Determines the minimum potential of the scission-point configuration
       represented by two deformed nuclei, divided by a tip distance d.
       A1, A2, Z1, Z2, d are fixed, beta1 and beta2 are searched for and returned on output '/

       Dim As Integer B_analytical = 0
        ' Switch to use the analytical approximation 
        ' that replaces the long numerical calculation.
       Dim As Single x,y,xcoul
       Dim As Single xcoul236U = 1369.64

       Dim As Single beta1,beta2
       
 '      Dim As Double U,Uprev,Ulast,Ubest,Uopt
       Dim As Single U,Uprev,Ulast,Ubest,Uopt

 '      Dim As Double sbeta1,sbeta2
       Dim As Single sbeta1 = 0
       Dim As Single sbeta2 = 0

       Dim As Integer N,N1,N2
       Dim As Integer Nopt = 0

 '      Dim As Double eps = 5.E-4
       Dim As Single eps = 5.E-4

       Dim As Integer I
       /'<FO REAL*4 LYMASS FO>'/       
       /'<FO REAL*4 ECOUL FO>'/       
       
       If B_analytical = 0 Then  ' Numerical algorithm

       beta1 = beta1prev
       beta2 = beta2prev
       Uprev = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
       Uopt = Uprev

       /' Test slope of variation of U '/
       beta1 = beta1prev + eps
       U = 1.E30

       beta2 = beta2prev
 '     For beta2 = beta2prev to 0 Step -eps
       For I = 1 To Int(beta2prev/eps)
         beta2 = beta2 - eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
           Exit For
         Else
           Ubest = U
         EndIf
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = eps
         sbeta2 = -eps
       EndIf

       U = 1.E30
       beta2 = beta2prev
   '   For beta2 = beta2prev To 1 Step eps
       For I = 1 To Int((1 - beta2prev)/eps)
         beta2 = beta2 + eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
            Exit For
         Else
           Ubest = U
         EndIf
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = eps
         sbeta2 = eps
       End If

       beta1 = beta1prev - eps
       U = 1.E30
       beta2 = beta2prev
   '   For beta2 = beta2prev To 0 Step -eps
       For I = 1 To Int(beta2prev/eps)
         beta2 = beta2 - eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
            Exit For
         Else
            Ubest = U
         End If
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = -eps
         sbeta2 = -eps
       EndIf

       U = 1.E30
       beta2 = beta2prev
   '   For beta2 = beta2prev To 1 Step eps
       For I = 1 To Int((1-beta2prev)/eps)
         beta2 = beta2 + eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
            Exit For
         Else
           Ubest = U
         EndIf
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = -eps
         sbeta2 = eps
       EndIf


      Ubest = Lymass(Z1,A1,beta1prev) + Lymass(Z2,A2,beta2prev) _
             + ECoul(Z1,A1,beta1prev,Z2,A2,beta2prev,d)
      U = Lymass(Z1,A1,beta1prev+Csng(sbeta1)) + _
          Lymass(Z2,A2,beta2prev+Csng(sbeta2)) + _
          ECoul(Z1,A1,beta1prev+sbeta1,Z2,A2,beta2prev+Csng(sbeta2),d)

'   L1:
       For N = 1 To 1000

'   L2:
         For N1 = 1 To N
           N2 = N-N1
           beta1 = beta1prev + sbeta1*N1
           beta2 = beta2prev + sbeta2*N2
           U = LyMass(Z1,A1,beta1) + _
               LyMass(Z2,A2,beta2) + _
               ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
           If U < Ubest Then
             Ubest = U
             beta1opt = beta1
             beta2opt = beta2
             Nopt = N
           EndIf
         Next
         If N-Nopt > 2 Then Exit For
       Next


       Else  ' Analytical approximation
        ' Must be adapted if the relevant parameters of GEF are modified!
         xcoul = (Z1 + Z2)^2 / (A1 + A2)^(1.0/3.0)
         x = (Z1 / (Z1 + Z2))^(xcoul/xcoul236U)
         y = 1.2512E-4 + 0.00122851*x - 0.00267707*x^2 _
                       + 0.00372901*x^3 - 0.00219903*x^4       
         beta1opt = y * xcoul 

         x = (Z2 / (Z1 + Z2))^(xcoul/xcoul236U)
         y = 1.2512E-4 + 0.00122851*x - 0.00267707*x^2 _
                       + 0.00372901*x^3 - 0.00219903*x^4       
         beta2opt = y * xcoul 
       
       End If

   End Sub

  Function U_Ired(Z As Single,A As Single) As Single
    ' Effective moment of inertia by pairing with correction for excitation energy
      Dim As Single I_rigid_spher,IfragEff
      
  '   /'<FO REAL*4 U_SHELL FO>'/
      
      I_rigid_spher = 1.16E0^2 * A^1.6667E0 / 103.8415E0 
  '   IfragEff = I_rigid_spher + 0.003 * A^(4.0/3.0) * U_shell(Cint(Z),Cint(A))
  '   IfragEff = I_rigid_spher + 0.005 * A^(4.0/3.0) * U_shell(Cint(Z),Cint(A))
                      ' reduction due to shell (Deleplanque et al. PRC 69 (2004) 044309)
      IfragEff = 0.45 * I_rigid_spher ' Effect of superfluidity 
  '   IfragEff = 0.65 * IfragEff   ' Average effect of superfluidity and deformation 

     U_Ired = IfragEff     
   End Function
   
  Function U_IredFF(Z As Single,A As Single) As Single
    ' Effective moment of inertia by pairing with correction for excitation energy
    ' of final fission fragments
    
      /'<FO REAL*4 U_Ired FO>'/    
      /'<FO REAL*4 U_I_Shell FO>'/    

     U_IredFF = U_Ired(Z,A) * U_I_Shell(Z,A)    
   End Function
   
   Function U_I_Shell(Z As Single,A As Single) As Single
      Dim As Integer N_shells(6)
      ' Shell effect on the effective moment of inertia
      Dim As Integer I 
      Dim As Single dNmin, dZmin, dNsubmin
      Dim As Single Inv_add = 0
      Dim As Single I_inv_add_Z = 0
      Dim As Single I_inv_add_N = 0
      Dim As Single I_inv_add_Nsub = 0
      N_shells(1) = 20
      N_shells(2) = 28
      N_shells(3) = 50
      N_shells(4) = 82
      N_shells(5) = 126
      N_shells(6) = 56
      dNmin = 100
      dZmin = 100
      dNsubmin = 100
      For I = 1 To 5
        dZmin = Min(dZmin,Abs(N_shells(I) - Z))
      Next I
      
      For I = 1 To 5
        dNmin = Min(dNmin,Abs(N_shells(I) - (A-Z))) 
      Next I  
      
      dNsubmin = Abs(N_shells(6) - (A-Z))
  
     ' Effect of shells:
      If dZmin < 10.0 Then
'        I_inv_add_Z = 0.33 * (6.0 * sqr(A/140.) - dZmin) * sqr(140./A)
        I_inv_add_Z = 0.33 * (6.0 * sqr(A/140.0) - dZmin) * (140.0/A)^1.5
        ' A^(-1/3) dependence: "A simple phenomenology for 2gamma+ states",
        ' N. V. Zamfir, D. Bucurescu, R. F. Casten, M. Ivascu,
        ' Phys. Lett. B 241 (1990) 463
        I_inv_add_Z = Max(I_inv_add_Z,0.0)
      End If
      If dNmin < 10.0 Then
'        I_inv_add_N = 0.42 * (8.0 * sqr(A/140.) - dNmin) * sqr(140./A)
        I_inv_add_N = 0.42 * (8.0 * sqr(A/140.0) - dNmin) * (140.0/A)^1.5
        I_inv_add_N = Max(I_inv_add_N,0.0)
      End If    
      If DNsubmin < 6.0 Then
   '    I_inv_add_Nsub = 1.7 * (4.0 - dNsubmin) * (1.0 - 0.32 * Abs(40.0-Z))
        I_inv_add_Nsub = 1.7 * (4.0 - dNsubmin) * (1.0 - 0.18 * Abs(40.0-Z))
            ' N = 56 subshell only around Z = 40
        I_inv_add_Nsub = Max(I_inv_add_Nsub,0.0)
      End If      
      U_I_shell = 1.0 / (1.0 + Max(I_inv_add_N,I_inv_add_Nsub) + I_inv_add_Z)
'Print "*",I_inv_add_Z, I_inv_add_N, I_inv_add_Nsub,1.0 / (1.0 + Max(I_inv_add_N,I_inv_add_Nsub) + I_inv_add_Z)  
   End Function
   

   Function U_alev_ld(Z As Single, A As Single) As Single
    '  U_alev_ld = 0.073 * A + 0.095 * A^0.666667  'Ignatyuk (1970's)
       U_alev_ld = 0.078 * A + 0.115 * A^0.6666667  ' Ignatyuk (Bologna 2000) 
    '  U_alev_ld = 0.089 * A    ' only volume term
   End Function
   
    
   Function U_Temp(Z As Single, A As Single, E As Single, Ishell As Integer, _
           Ipair As Integer, Tscale As Single,Econd As Single,Etrans As Single) As Single
       ' Temperature (modified Gilbert-Cameron composite level density)    
       ' KHS (10. 2. 2012)       
       Dim As Single alev  
       Dim As Single Eeff0,Eeff1,E1,Rho0,Rho1,TCT,TFG 
       Static As Single fgamma = 0.055      
       Dim As Single RShell,RPair,Res
       /'<FO REAL*4 U_ALEV_LD FO>'/
       /'<FO REAL*4 U_SHELL FO>'/
       /'<FO REAL*4 LYPAIR FO>'/
       /'<FO REAL*4 TEGIDY FO>'/ 
       ' Used global parameters: Tscale
    '   alev = U_alev_ld(Z,A) * 1.1   ' Factor adjusted to high-energy prompt neutrons in U235(nth,f)
       alev = U_alev_ld(Z,A) * 0.95  ' " with the correction for non-constant T (FG range)
    '  alev = U_alev_ld(Z,A)
       
       If Ishell = 1 Then
         RShell = U_Shell(Cint(Z),Cint(A))
       Else
         RShell = 0.0
       End If    
       TCT = TEgidy(A,RShell,Tscale)  
       
       If Ipair = 1 Then
         RPair = Lypair(CInt(Z),CInt(A))
       Else
         Rpair = 0.0
       End If    
       Eeff0 = E - Econd + RPair + Rshell*(1.0 - exp(-fgamma * E))
       
       If Eeff0 > 0.5 Then
  '       Eeff1 = Eeff0 + 0.1
         E1 = E + 0.1
         Eeff1 = E1 - Econd + RPair + Rshell*(1.0 - exp(-fgamma * E1))
         Rho0 = 1.E0/Eeff0^1.25 * exp(2.E0 * sqr(alev * Eeff0))
         Rho1 = 1.E0/Eeff1^1.25 * exp(2.E0 * sqr(alev * Eeff1))
'         Rho0 = 1.E0/Eeff0 * exp(2.E0 * sqr(alev * Eeff0))
'         Rho1 = 1.E0/Eeff1 * exp(2.E0 * sqr(alev * Eeff1))
         TFG = 0.1E0 / (log(Rho1) - log(Rho0))
       Else 
         TFG = 0.0
       End If
       Res = TCT
       If TFG > Res Then Res = TFG

' If Res > 1.4 Then Res = 1.4

       U_Temp = Res
   End Function

 Function U_Even_Odd(I_Channel As Integer,PEO As Single) As Single
   ' Creates even-odd fluctuations 
   Dim As Single R
   If I_Channel Mod 2 = 0 Then
     R = 1.0 + PEO
   Else
     R = 1.0 - PEO
   End If
   U_Even_Odd = R   
 End Function
 

   Function BFTF(RZ As Single,RA As Single,I_Switch As Integer) As Single
    /' Fission barriers from Myers and Swiatecki, Thomas-Fermi model '/
    /'  I_Switch: 0: liquid-drop; 1: with shells and pairing, 
        2: averaged over pairing, 3: with shell and pairing + pairing gap at barrier '/
      ' 4: liquid-drop + g.s. shell, no Z correction
      Dim As Single RN,RI,Rkappa,RS,RF,RX
      Dim As Single RX0 = 48.5428
      Dim As Single RX1 = 34.15
      Dim As Single RB 
      Dim As Integer IZ,IA
   '  /'<FO REAL*4 U_SHELL FO>'/
     /'<FO REAL*4 U_SHELL_EXP FO>'/
     /'<FO REAL*4 U_SHELL_EO_EXP FO>'/
     /'<FO REAL*4 LYPAIR FO>'/
     
     IZ = Cint(RZ)
     IA = Cint(RA)
     RN = RA - RZ
     RI = (RN-RZ) / RA
     Rkappa = 1.9E0 + (RZ - 80.E0) / 75.E0
     RS = RA^0.666667E0 * (1.E0 - Rkappa * RI^2)
     RX = RZ^2 / (RA * (1.E0 - Rkappa * RI^2))
     If RX < 30 Then   /' out of range '/
       RF = 1.E10
     End If
     If RX > RX0 Then  /' out of range '/
       RF = 0.0
     End If
     If RX < RX1 And RX > 30 Then 
       RF = 0.595553E0 - 0.124136E0 * (RX - RX1)
     End If
     If RX >= RX1 And RX <= RX0 Then 
       RF = 0.000199749 * (RX0 - RX)^3
     End If
     RB = RF * RS

     Select Case I_Switch
       Case 0  ' no shell, no pairing
         BFTF = RB
       Case 1 ' including even-odd staggering due to increased pairing strength at barrier
         ' Tentative modification from comparison with experimental fission barriers
         ' (shell correction at the barrier?)
         If RZ > 86.5 Then RB = RB - 0.15 * (RZ - 86.5)
     '    If RZ > 90 Then RB = RB + 0.3 * (RZ - 90.0)
     '    If RZ > 98 Then RB = RB - 0.15 * (RZ - 98.0) 
         If RZ > 90 Then RB = RB + 0.35 * (RZ - 90.0)
         If RZ > 93 Then RB = RB + 0.15 * (RZ - 93.0)
         If RZ > 95 Then RB = RB - 0.25 * (RZ - 95.0) 
     '    BFTF = RB - U_Shell(IZ,IA)
     '    BFTF = RB - U_Shell_exp(IZ,IA)
          BFTF = RB - U_Shell_EO_exp(IZ,IA) + Lypair(IZ,IA) * 14.0/12.0
   '   BFTF = RB - U_Shell_EO_exp(RZ,RA) - 14.E0 / sqr(Csng(RA)) _
   '       * Csng( ( (RZ+1) Mod 2 + (RA-RZ+1) Mod 2) )
       Case 2 ' averaged over even-odd staggering
         If RZ > 86.5 Then RB = RB - 0.15 * (RZ - 86.5)
         If RZ > 90 Then RB = RB + 0.35 * (RZ - 90.0)
         If RZ > 93 Then RB = RB + 0.15 * (RZ - 93.0)
         If RZ > 95 Then RB = RB - 0.25 * (RZ - 95.0) 
         BFTF = RB - U_Shell_exp(IZ,IA)
       Case 3 ' like Case 1 but without increased pairing gap at barrier
         If RZ > 86.5 Then RB = RB - 0.15 * (RZ - 86.5)
         If RZ > 90 Then RB = RB + 0.35 * (RZ - 90.0)
         If RZ > 93 Then RB = RB + 0.15 * (RZ - 93.0)
         If RZ > 95 Then RB = RB - 0.25 * (RZ - 95.0) 
         BFTF = RB - U_Shell_EO_exp(IZ,IA) 
       Case 4 ' like case 3 but without Z correction
       ' This is the direct description from the topographic theorem.
         BFTF = RB - U_Shell_exp(IZ,IA)
       Case Else
         Print "Undefined option in BFTF"
'         Sleep
     End Select  
 /'  If I_Switch = 0 Then 
       BFTF = RB
     Else 
      ' Tentative modification from comparison with experimental fission barriers
      ' (shell correction at the barrier?)
       If RZ > 86.5 Then RB = RB - 0.15 * (RZ - 86.5)
   '    If RZ > 90 Then RB = RB + 0.3 * (RZ - 90.0)
   '    If RZ > 98 Then RB = RB - 0.15 * (RZ - 98.0) 
       If RZ > 90 Then RB = RB + 0.35 * (RZ - 90.0)
       If RZ > 93 Then RB = RB + 0.15 * (RZ - 93.0)
       If RZ > 95 Then RB = RB - 0.25 * (RZ - 95.0) 
          
   '    BFTF = RB - U_Shell(IZ,IA)
   '    BFTF = RB - U_Shell_exp(IZ,IA)
       BFTF = RB - U_Shell_EO_exp(IZ,IA) + Lypair(IZ,IA) * 14.0/12.0
     End If '/
   End Function

   Function BFTFA(RZ As Single,RA As Single,I_Switch As Integer) As Single
    /' inner barrier height '/
     Dim As Single EA,BF0,Z4A,Z3A,DB 
     Dim As Single coeff = 0.5
     /'<FO REAL*4 BFTF FO>'/
     BF0 = BFTF(RZ,RA,I_Switch)
   ' Z4A = RZ^4 / RA
     '  EB - EA from fit to Smirenkin barriers:
     '  V. M. Kupriyanov, K. K. Istekov, B. I. Fursov, G. N. Smirenkin
     '  Sov. J. Nucl. Phys. 32 (1980) 184
   '  DB = -10.3517 + 1.6027E-5 * Z4A + 5.4945E-11 * Z4A^2  ' EA - EB
   
     '  EB - EA from fit to data from Dahlinger et al. (KHS, 21. Dec. 2012)
     Z3A = RZ^3 / RA
     DB = -(5.40101 - 0.00666175*Z3A + 1.52531E-6*Z3A^2)
     If DB > 0.0 Then
       EA = BF0 - DB
     Else
       EA = BF0 
     End If 
     BFTFA = EA
   End Function

   Function BFTFB(RZ As Single,RA As Single,I_Switch As Integer) As Single
    /' outer barrier height '/
     Dim As Single EB,BF0,Z4A,Z3A,DB 
     Dim As Single coeff = 0.5
     /'<FO REAL*4 BFTF FO>'/
     BF0 = BFTF(RZ,RA,I_Switch)
   ' Z4A = RZ^4 / RA
     '  EB - EA from fit to Smirenkin barriers:
     '  V. M. Kupriyanov, K. K. Istekov, B. I. Fursov, G. N. Smirenkin
     '  Sov. J. Nucl. Phys. 32 (1980) 184
  '   DB = -10.3517 + 1.6027E-5 * Z4A + 5.4945E-11 * Z4A^2  ' EA - EB
  
     '  EB - EA from fit to data from Dahlinger et al. (KHS, 21. Dec. 2012)
     Z3A = RZ^3 / RA
     DB = -(5.40101 - 0.00666175*Z3A + 1.52531E-6*Z3A^2)  
     If DB < 0.0 Then
       EB = BF0 + DB
     Else
       EB = BF0 
     End If 
     BFTFB = EB
   End Function
   


   /' Utility functions '/


   Function Gaussintegral(R_x As Single,R_sigma As Single) As Single
     /' Smoothed step function. Grows from 0 to 1 around R_x
        with a Gauss-integral function with given sigma'/
     Dim As Single R_ret
     ' Note: The variable R_sigma = standard deviation / sqr(2) !
     /'<FO REAL*4 ERF FO>'/
       R_ret = 0.5E0 + 0.5E0 * Erf(R_x / R_sigma)
       Gaussintegral = R_ret
   End Function
   
   Public Function Bell(xpos As Single, xleft As Single, xright As Single) As Single
   ' Bell-shaped curve, maximum = 1, zero for x < xleft and x > xright
     Dim As Single x,y
     If xpos - xleft > 1.E-3 And xright - xpos > 1.E-3 Then
       x = (xpos - xleft) / (xright - xleft)
       y = (x^2 * (1-x)^2)/0.0625
     Else
       y = 0
     End If    
     Bell = y
   End Function     

   Function U_Box(x As Single,sigma As Single, _
         length As Single) As Single
     Dim As Single y
     ' Note: The variable sigma = standard deviation / sqr(2) !
     /'<FO REAL*4 GAUSSINTEGRAL FO>'/      
     y = Gaussintegral(x+0.5*length,sigma) - Gaussintegral(x-0.5*length,sigma)
     U_Box = y/length
   End Function
   
   Function U_Box2(x As Single,sigma1 As Single, sigma2 As Single, _
         length As Single) As Single
     Dim As Single y
     ' Note: The variable sigma = standard deviation / sqr(2) !
     /'<FO REAL*4 GAUSSINTEGRAL FO>'/      
     y = Gaussintegral(x+0.5*length,sigma2) - Gaussintegral(x-0.5*length,sigma1)
     U_Box2 = y/length
   End Function
   
   Function U_Gauss(x As Single,sigma As Single) As Single
     Dim As Single y
     /'<FO Const As Single pi = 3.14159 FO>'/      
     
     y = 1.0 / (sqr(2.0 * pi) * sigma) * exp(-x^2/ ( 2.0 * sigma^2 ) )
     U_Gauss = y
   End Function  
   
   Function U_Gauss_abs(x As Single,sigma As Single) As Single
     Dim As Single y
     /'<FO Const As Single pi = 3.14159 FO>'/      
     
     y = exp(-x^2/ ( 2.0 * sigma^2 ) )
     U_Gauss_abs = y
   End Function  

   Function U_Gauss_mod(x As Single,sigma As Single) As Single
    ' Gaussian with Sheppard correction
     Dim As Single y
     Dim As Single sigma_mod
     /'<FO Const As Single pi = 3.14159 FO>'/      
     sigma_mod = sqr(sigma^2 + 1./12.)
     
     y = 1.0 / (sqr(2.0 * pi) * sigma_mod) * exp(-x^2/ ( 2.0 * sigma_mod^2 ) )
     U_Gauss_mod = y
   End Function  

Public Function U_LinGauss(x As Single, R_Sigma As Single) As Single
  /' Gaussian times a linear function '/
  /' Not normalized! '/
  Dim As Single R_Res
  If R_Sigma > 0.0 Then
    R_Res = x * exp(-x^2/(2.0 * R_Sigma^2))
  Else
    R_Res = 0.0
  End If    
  U_LinGauss = R_Res
End Function
 
